(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: sut.ml
** Author: jahier@imag.fr
*)

(* open Var *)
open Value
open Ocaml2c


type var_type = string

(* ------------------------------------------------------------------------ *)

let (struct_array_to_pair_list : Ocaml2c.vn_t array -> (string * string) list) =
  fun a ->
    (Array.fold_right 
       (fun stru acc -> (stru.var_name, stru.var_type)::acc) a [])

(*********************************************************************)

let (init : unit -> unit) =
  Ocaml2c.lurette__sut_init

let (get_input_var_name_and_type : unit -> (string * string) list) = 
  fun () -> 
    struct_array_to_pair_list
      (Ocaml2c.lurette__sut_input_var_name_and_type_array (Ocaml2c.lurette__sut_input_arg_nb()))

let (get_output_var_name_and_type : unit -> (string * string) list) =
  fun () -> 
    struct_array_to_pair_list
      (Ocaml2c.lurette__sut_output_var_name_and_type_array (Ocaml2c.lurette__sut_output_arg_nb()))


(* let (step : unit -> unit) = Ocaml2c.lurette__sut_step *)
(* let (restore_state : unit -> unit) = Ocaml2c.lurette__sut_restore_state *)
(* let (get_val_int : int -> int) = Ocaml2c.lurette__sut_get_val_int *)
(* let (get_val_float : int -> float) = Ocaml2c.lurette__sut_get_val_float *)
(* let (get_val_bool : int -> bool) = Ocaml2c.lurette__sut_get_val_bool *)
(* let (set_val_int : int -> int -> unit) = Ocaml2c.lurette__sut_set_val_int *)
(* let (set_val_float : int -> float -> unit) = Ocaml2c.lurette__sut_set_val_float *)
(* let (set_val_bool : int -> bool -> unit) = Ocaml2c.lurette__sut_set_val_bool *)


(* ------------------------------------------------------------------------ *)


let sut_input_arg_nb = Ocaml2c.lurette__sut_input_arg_nb()
let sut_output_arg_nb = Ocaml2c.lurette__sut_output_arg_nb()
let sut_i_vntl = get_input_var_name_and_type ()
let sut_o_vntl = get_output_var_name_and_type ()



let (set_sut_input: Value.OfIdent.t -> unit) =
  fun input ->
    let _ =
      (List.fold_left
	      (fun j (vn, t) ->
            let value = try (Value.OfIdent.get input vn) with
                Not_found -> (
                  Printf.fprintf stderr
                    "internal error in Sut.set_sut_input\n  while searching input \"%s\" value\n" vn;
                  exit 13
                ) in
	           (match value with
		             B(b) -> Ocaml2c.lurette__sut_set_val_bool j b
		           | N(I(i)) -> Ocaml2c.lurette__sut_set_val_int j (Util.int_of_num i)
		           | N(F(f)) -> Ocaml2c.lurette__sut_set_val_float j f
	           );
	           (j+1)
	      )
	      0
	      sut_i_vntl
      )
    in
      ()

let (trie : Value.OfIdent.t -> Value.OfIdent.t) =
  fun input ->
    Ocaml2c.lurette__sut_restore_state ();
    set_sut_input input;
    Ocaml2c.lurette__sut_step () ;

    let (_, tbl) =
      (List.fold_left
	      (fun (j,tbl) (vn, t) ->
	         let value =
	           match t with
		            "bool" ->
		              let b = Ocaml2c.lurette__sut_get_val_bool j in
		                B(b)
		          | "int" ->
		              let i = Ocaml2c.lurette__sut_get_val_int j in
		                N(I(Num.num_of_int i))
		          | "float" ->
		              let f = Ocaml2c.lurette__sut_get_val_float j in
		                N(F(f))
		          | _  -> assert false
	         in
	         let tbl = Value.OfIdent.add tbl (vn,value) in
	           (j+1, tbl)
	      )
	      (0, Value.OfIdent.empty)
	      sut_o_vntl
      )
    in
      tbl


let (step :  Value.OfIdent.t -> Value.OfIdent.t) =
  fun input ->
    let output = trie input in 
      Ocaml2c.lurette__sut_save_state ();
      output

