(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: sim2chro.mli
** Main author: jahier@imag.fr
*)


(* XXX obselete : use the Rif module instead !!! *)

(** Functions to display variable values history with sim2chro. *)



(** [put_var_decl title in_vn out_vn rif display_local_var] puts the
  variable names and types (from [env_state]) in the file associated
  to [rif]. [display_local_var] is a boolean telling whether or not
  local vars should be displayed in the chronogram.  [in_vn] and
  [out_vn] are the list of sut inputs and outputs variable names and
  types. [title] is a string that is used to set a title to the
  lurette window.
*)
val put_var_decl : string -> (string * string) list -> (string * string) list
  -> (string * string) list -> out_channel -> bool -> unit

(**
  [put_current_step_values rif t input output local display_local_var]
  puts the values computed at times [t]. [input], [output], and [local]
  contain the values to be displayed. [display_local_var] tells whether
  or not to display local vars.
*)
val put_current_step_values : out_channel -> int -> Var.env_out -> Var.env_in ->
  Var.env_loc -> bool -> (string * string) list -> (string * string) list -> 
  (string * string) list -> unit

(**
  [call_sim2chro rif_file] calls (fork) sim2chro to display datas contained
  in [rif_file].
*)
val call_sim2chro : Prog.state -> string -> unit


val put_oracle_step_values: out_channel -> Var.env -> unit
