(*-----------------------------------------------------------------------
** Copyright(C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: sim2chro.ml
** Main author: jahier@imag.fr
*)

(* XXX obselete : use the Rif module instead !!! *)

open Constraint
open List

type ssl = (string * string) list

let (put_var_decl: string -> ssl -> ssl -> ssl -> out_channel -> bool -> unit) =
  fun title
      sut_input_var_name_and_type_list
      sut_output_var_name_and_type_list
      local_var_name_and_type_list
      rif
      display_local_var
      ->
    let put s = output_string rif s in
    let put_vt = function
	"boolean" -> put "bool"
      | "float" -> put "real"
      | any -> put any
    in
    let put_vntl =
      (fun (vn,vt) -> put ("\"" ^ vn^ "\""); put ":"; put_vt vt; put "\n")
    in

      put ("#program \"" ^ title ^ " \"\n");

      put "#@inputs\n";
      List.iter put_vntl sut_input_var_name_and_type_list;

      put "@#\n#@outputs\n";
      List.iter put_vntl sut_output_var_name_and_type_list;

      if display_local_var then
	(
	  put "@#\n#@locals\n";
	  List.iter put_vntl local_var_name_and_type_list
	);

      put "@#\n"

let (put_current_step_values: out_channel -> int -> Var.env_out -> Var.env_in ->
       Var.env_loc -> bool -> ssl -> ssl -> ssl -> unit) =
  fun rif
      t
      input
      output
      local
      display_local_var
      sut_output_var_name_and_type_list
      sut_input_var_name_and_type_list
      local_var_name_and_type_list
      
      ->
    let put s = output_string rif s in
      put "#step ";
      put (string_of_int t);
      put "\n";

      List.iter
	(fun (vn, _) ->
	   let e = Var.get_val_env_out input vn in
(* 	      put (vn ^ ":"); *)
	     (Value.print rif e)
	)
	sut_input_var_name_and_type_list;


      put "#outs "; (* output of the sut *)
      List.iter
	(fun (vn,_) ->
(* 	   put (vn ^ ":"); *)
           let value = try (Value.OfIdent.get output vn) with
           Not_found -> (
              Printf.fprintf stderr
                "internal error in Sim2chro.put_current_step_values\n  while searching output \"%s\" value\n" vn;
               Printf.fprintf stderr "  known outputs are:\n%s" (Value.OfIdent.to_string "  " output);
              exit 13
           ) in
	   Value.print rif value
	)
	sut_output_var_name_and_type_list;

  if display_local_var then
    ( 
	  put "\n#locs "; (* output of the sut *)
	  List.iter
	   (fun (vn, e) ->
	      (Value.print rif e))
	   (Value.OfIdent.content local);
	) ;

      put "\n"


let (put_oracle_step_values: out_channel -> Var.env -> unit) =
  (* WARNING ! the order is RANDOM *)
  fun oc vals ->
    let put s = output_string oc s in
      put "#oracle_outputs ";
      let values = Value.OfIdent.content vals in 
      List.iter
	(fun (v,vv) -> put ((Value.to_string vv) ^  " "))
	values;
      put "\n"


open Prog


(* XXX won't work on win32 -> use create_process!! *)
let call_sim2chro state output_file =
  let color_option =
    (* options for sim2chro to display local vars in green *)
    let loc_var_names = state.s.loc_vars in
    let varcolor_str =
      fold_left
	(fun acc var ->
	   (acc ^ " -varcolor " ^ (Var.name var) ^ " LightGreen "))
	""
	loc_var_names
    in
    let varnamecolor_str =
      fold_left
	(fun acc v ->
	   (acc ^ " -varnamecolor " ^ (Var.name v) ^ " LightGreen "))
	""
	loc_var_names
    in
    let varnumcolor_str =
      fold_left
	(fun acc v ->
	   (acc ^ " -varnumcolor " ^ (Var.name v) ^ " LightGreen "))
	""
	loc_var_names
    in
      (varcolor_str ^ varnamecolor_str ^ varnumcolor_str)
  in
  let sim2chro =
    try Sys.getenv "SIM2CHRO"
    with _ -> "sim2chro"
  in
  let cmd = (sim2chro ^ " -ecran " ^ color_option ^
	     " -in " ^ output_file ^ " > /dev/null &")
  in
  let _ = output_string stderr (cmd ^ "\n") in
  let _ = Sys.command cmd in
    ()

