

(* abstract reactive program *)
type prg = DoStep of (Value.t list -> Value.t list * prg)
val step : prg -> Value.t list -> (Value.t list * prg)

type ctx = Event.t
type e = Event.t

type prg_ldbg = 
    DoStep_ldbg of (ctx ->  Value.t list ->  (ctx -> prg_ldbg -> Value.t list -> e) ->
                    (ctx -> e) -> (ctx -> string -> e) -> e)
  
val step_ldbg : ctx -> prg_ldbg -> Value.t list 
                 -> (ctx -> prg_ldbg -> Value.t list -> e)
                 ->  (ctx -> e) -> (ctx -> string -> e) -> e



