

(* abstract reactive program *)
type prg = DoStep of (Value.t list -> Value.t list * prg)

let step p = match p with DoStep _p -> _p


type ctx = Event.t
type e = Event.t

type prg_ldbg = 
    DoStep_ldbg of (ctx ->  Value.t list ->  (ctx -> prg_ldbg -> Value.t list -> e) ->
                    (ctx -> e) -> (ctx -> string -> e) -> e)

 let (step_ldbg : ctx -> prg_ldbg -> Value.t list 
                 -> (ctx -> prg_ldbg -> Value.t list -> e)
                 ->  (ctx -> e) -> (ctx -> string -> e) -> e) =
  fun ctx p vl cont fail_cont -> 
    match p with DoStep_ldbg _p -> _p ctx vl cont fail_cont
