(*-----------------------------------------------------------------------
** Copyright (C) 2001 - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: print.mli
** Main author: jahier@imag.fr
*)

(** Various printers to be used mainly in camldebug. *)


val linear_constraint : Constraint.t -> unit

val int_string_hashtbl : (int, string) Hashtbl.t -> unit
val int_float_hashtbl : (int, float) Hashtbl.t -> unit
val string_int_hashtbl : (string, int) Hashtbl.t -> unit
val string_var_value_hashtbl: (string, Value.t) Hashtbl.t -> unit


val subst_list : Var.subst list -> unit


val arc_info : LucParse.arc_info -> unit
val store : Store.t -> unit

(*
val comb: Bdd.t -> unit
val print_bdd : Bdd.t -> unit

(* open Big_int *)
(* val snt: (Bdd.t, (big_int * big_int)) Hashtbl.t -> unit  *)


val bdd_to_graph: Bdd.t -> (int -> string) -> (string * string * string) list
val bdd_with_dot: Bdd.t -> (int -> string) -> string -> unit
*)

val vn_str : out_channel -> (string * string) list -> unit

