(*-----------------------------------------------------------------------
** Copyright (C) 2001, 2002 - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: print.ml
** Author: jahier@imag.fr
*)


(*
ocamlc -c print.ml
(ocd)
      load_printer print.cmo
      install_printer Print.linear_constraint
 (ocd)
*)

open Constraint
open Format


let (var : Exp.var -> unit) =
  fun var ->
    print_string (Var.name var) ;
    print_string (":" ^ (Type.to_string (Var.typ var))) ;

    ()

let (linear_constraint : Constraint.t -> unit) =
  fun af ->
    print_string ((Constraint.to_string af) ^ "\n")

let (store : Store.t -> unit) =
  fun s ->
    print_string (Store.to_string s)


let (subst_list: Var.subst list -> unit) =
  fun sl ->
    Var.print_subst_list sl stdout

let (int_string_hashtbl: (int, string) Hashtbl.t -> unit) =
  fun t ->
    Hashtbl.iter
       (fun i str -> print_int i ; print_string (" : " ^ str ^ "\n"))
       t

let (int_float_hashtbl: (int, float) Hashtbl.t -> unit) =
  fun t ->
    Hashtbl.iter
       (fun i f -> print_int i ; print_string (" : " ^ (string_of_float f) ^ "\n"))
       t

let (string_int_hashtbl: (string, int) Hashtbl.t -> unit) =
  fun t ->
    Hashtbl.iter
       (fun str i -> print_int i ; print_string (" : " ^ str ^ "\n"))
       t

let (string_var_value_hashtbl: (string, Value.t) Hashtbl.t -> unit) =
  fun t ->
    Hashtbl.iter
       (fun str vv ->
	  print_string str ; print_string " : " ;
	  Value.print stdout vv ;
	  print_string "\n"
       )
       t




(* type arc_info = weight * formula *)

let (arc_info : LucParse.arc_info -> unit) =
  fun (_, w, f) ->
    print_string (
      (Exp.weight_to_string w) ^ " " ^
      (Exp.formula_to_string f) ^ "\n")



let print_table_entry nl f =
    List.iter (fun i -> print_string ((string_of_int i) ^ ", ")) nl ;
    print_string (" -> " ^ (Exp.formula_to_string f) ^ "\n")


(****************************************************************************)

(* let print_list =  *)
(*   function *)
(*       [] -> print_string  *)





(****************************************************************************)


let print_node n =
  List.iter
    (fun i -> print_int i; print_string " ") n

let indent d =
  let str = String.make d ' ' in
    print_string ("\n" ^ str)


(*
let (comb2: Bdd.t -> unit) =
  fun supp ->
    List.iter
    (fun var -> print_string (var ^ " "))
    (List.map
       (fun index -> (Constraint.t_to_string (Env_state.index_to_linear_constraint index)))
       (Bdd.list_of_support supp));
    print_string "\n" ;
    flush stdout


let rec (comb : Bdd.t -> unit) =
  fun supp ->
    if Bdd.is_cst supp then print_string "\n"
    else
      begin
	print_string (
	  (Constraint.t_to_string
	     (Env_state.index_to_linear_constraint (Bdd.topvar supp)))
	  ^ " ");
	comb (Bdd.dthen supp);
	flush stdout
      end

(*     let _ =  *)
(*       List.iter  *)
(* 	(fun x -> print_int (Dd.level_of_var (Env_state.vn_to_index x)) ; print_string " ") *)
(* 	vars_to_gen; *)
(*       print_string "\n"; *)
(*       flush stdout *)
(*     in *)


let rec (print_bdd : Bdd.t -> unit) =
  fun bdd ->
    Bdd._print bdd


(****************************************************************************)
(* printing bbd's with dot *)



let (bdd_to_graph: Bdd.t -> (int -> string) -> (string * string * string) list) =
  fun bdd index_to_string ->
    let get_label bdd =
      if Bdd.is_true bdd then "True"
      else if Bdd.is_false bdd then "False"
      else index_to_string (Bdd.topvar bdd)
    in
    let rec (bdd_to_graph_acc: (string * string * string) list -> Bdd.t -> (string * string * string) list) =
      fun acc0 bdd ->
	if Bdd.is_cst bdd then acc0
	else
	  let bddt = Bdd.dthen bdd in
	  let bdde = Bdd.delse bdd in
	  let label = get_label  bdd in
	  let labelt = get_label bddt in
	  let labele = get_label bdde in
	  let acc1 =
	    if List.mem (label, "t", labelt) acc0
	    then acc0
	    else ((label,"t", labelt)::acc0)
	  in
	  let acc2 =
	    if List.mem (label, "f", labele) acc1
	    then acc1
	    else ((label, "f", labele)::acc1)
	  in
	  let acc3 = bdd_to_graph_acc acc2 bddt in
	    bdd_to_graph_acc acc3 bdde
    in
      bdd_to_graph_acc [] bdd


let (bdd_with_dot: Bdd.t -> (int -> string) -> string -> unit) =
  fun bdd index_to_vn label ->
    let arcs = bdd_to_graph bdd (index_to_vn) in
    let dot_file = label ^ ".dot" in
    let ps_file = label ^ ".ps" in
    let dot_oc = open_out dot_file in
    let put = output_string dot_oc in
    let _ =
      put "digraph G {\n\n ordering=out;\n\n";
      put " ratio = compress;\n\n";
      List.iter (fun (n, _, _) -> put ("\t" ^ n ^ "\t ; \n")) arcs ;
      List.iter (fun (f, l, t) -> put ("\t" ^ f ^ " -> " ^ t ^ "\t  [label = " ^ l ^ " ] ; \n")) arcs ;
      put "} \n";
      flush dot_oc ;
      close_out dot_oc
    in
      (*  Calling dot to create the postscript file *)
    let exit_code_dot = Sys.command ("dot -Tps " ^ dot_file ^ " -o " ^ ps_file)
    in if (exit_code_dot <> 0)
      then print_string " Can't call dot; is dot in your path?\n\n"
      else ()


open Util
let (snt: (Bdd.t, (Util.sol_nb * Util.sol_nb)) Hashtbl.t -> unit) =
  fun t ->
    Hashtbl.iter
    (fun bdd (n,m) ->
      let n_str = string_of_sol_nb n
      and m_str = string_of_sol_nb m in
	bdd_with_dot bdd
	  (fun index -> Constraint.t_to_string (Env_state.index_to_linear_constraint  index))
	  ("bdd__" ^ n_str ^ "__" ^ m_str ^ "_" ^ (string_of_int (Hashtbl.hash bdd)));
    )
    t

*)



let (vn_str : out_channel -> (string * string) list -> unit) =
  fun oc vl ->
    List.iter
      (fun (v, t) ->
	 output_string oc ("\n\t\"" ^ v ^ "\" of type\t" ^ t ^ ","))
      vl
