(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: parse_poc.mli
** Main author: jahier@imag.fr
*)

open Gen_stubs_common

(** [get_vn_and_ct_list file_h] parses a C header file and
  returns the list of input,  output, and local var names and types.

 nb: sildex C programs have the following shape:


/* Inputs */ 
	type1 var_name1;
	type2 var_name2;
        ...
/* Outputs */  
	type1 var_name1;
	type2 var_name2;
        ...
/* Locals */  
	type1 var_name1;
	type2 var_name2;
        ...

we need to get local to be able to save and restore the context for lurette tries

*)
val get_vn_and_ct_list : file -> typedef list * vn_ct list * vn_ct list
