(*pp camlp4o *)
(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: parse_poc.ml
** Main author: jahier@imag.fr
**
*)

open Lexing
open MyGenlex
open Gen_stubs_common


let lexer = make_lexer [
  "long"; "short"; "int"; "signed"; "unsigned";
  "float"; "double"; "char"; 
  "."; ","; "{"; "}"; ";"; ":"; "("; ")"; "["; "]";
  "/*"; "*/"; "#"]


(****************************************************************************)




let rec (find_inputs: Lexing.lexbuf -> token Stream.t -> vn_ct list) = 
  fun ic tok  -> 
    let _ = print_debug ic ("find_inputs \n") tok in
      try
	(match tok with parser
	    [< 'Kwd (_, "/*");  vi = find_inputs2 ic >] -> vi
	  | [< 'Ident (_, _) >] -> find_inputs ic tok
	  | [< 'Kwd (_, _) >] -> find_inputs ic tok
	  | [< 'Int (_, _) >] -> find_inputs ic tok
	  | [< 'Float (_, _) >] -> find_inputs ic tok
	  | [< 'Char (_, _) >] -> find_inputs ic tok
	  | [< 'String (_, _) >] -> find_inputs ic tok
	)
      with _ -> []

and find_inputs2 ic tok =
    let _ = print_debug ic ("find_inputs2 \n") tok in
      match tok with parser
	  [< 
	    'Ident (_, "Inputs"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
	| [< 
	    'Ident (_, "INPUTS"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
	
	| [< 'Ident (_, _) >] -> find_inputs ic tok
	| [< 'Kwd (_, _) >] -> find_inputs ic tok
	| [< 'Int (_, _) >] -> find_inputs ic tok
	| [< 'Float (_, _) >] -> find_inputs ic tok
	| [< 'Char (_, _) >] -> find_inputs ic tok
	| [< 'String (_, _) >] -> find_inputs ic tok

and (find_outputs: Lexing.lexbuf -> token Stream.t -> vn_ct list) = 
  fun ic tok  -> 
    let _ = print_debug ic ("find_outputs \n") tok in
      try
	(match tok with parser
	  [< 'Kwd (_, "/*");  vo = find_outputs2 ic >] -> vo
	| [< 'Ident (_, _) >] -> find_outputs ic tok
	| [< 'Kwd (_, _) >] -> find_outputs ic tok
	| [< 'Int (_, _) >] -> find_outputs ic tok
	| [< 'Float (_, _) >] -> find_outputs ic tok
	| [< 'Char (_, _) >] -> find_outputs ic tok
	| [< 'String (_, _) >] -> find_outputs ic tok
	)
      with _ -> []
and find_outputs2 ic tok =
    let _ = print_debug ic ("find_outputs2 \n") tok in
      match tok with parser
	  [< 
	    'Ident (_, "Outputs"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
 
	| [< 
	    'Ident (_, "OUTPUTS"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
	
	| [< 'Ident (_, _) >] -> find_outputs ic tok
	| [< 'Kwd (_, _) >] -> find_outputs ic tok
	| [< 'Int (_, _) >] -> find_outputs ic tok
	| [< 'Float (_, _) >] -> find_outputs ic tok
	| [< 'Char (_, _) >] -> find_outputs ic tok
	| [< 'String (_, _) >] -> find_outputs ic tok


and (find_locals: Lexing.lexbuf -> token Stream.t -> vn_ct list) = 
  fun ic tok  -> 
    let _ = print_debug ic ("find_locals \n") tok in
      try
	(match tok with parser
	  [< 'Kwd (_, "/*");  vo = find_locals2 ic >] -> vo
	| [< 'Ident (_, _) >] -> find_locals ic tok
	| [< 'Kwd (_, _) >] -> find_locals ic tok
	| [< 'Int (_, _) >] -> find_locals ic tok
	| [< 'Float (_, _) >] -> find_locals ic tok
	| [< 'Char (_, _) >] -> find_locals ic tok
	| [< 'String (_, _) >] -> find_locals ic tok
	)
      with _ -> []
and find_locals2 ic tok =
    let _ = print_debug ic ("find_locals2 \n") tok in
      match tok with parser
	  [< 
	    'Ident (_, "Locals"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
 
	| [< 
	    'Ident (_, "LOCALS"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
	
	| [< 'Ident (_, _) >] -> find_locals ic tok
	| [< 'Kwd (_, _) >] -> find_locals ic tok
	| [< 'Int (_, _) >] -> find_locals ic tok
	| [< 'Float (_, _) >] -> find_locals ic tok
	| [< 'Char (_, _) >] -> find_locals ic tok
	| [< 'String (_, _) >] -> find_locals ic tok
	
and (find_states_var: Lexing.lexbuf -> token Stream.t -> vn_ct list) = 
  fun ic tok  -> 
    let _ = print_debug ic ("find_states_var \n") tok in
      try
	(match tok with parser
	  [< 'Kwd (_, "/*");  vo = find_states_var2 ic >] -> vo
	| [< 'Ident (_, _) >] -> find_states_var ic tok
	| [< 'Kwd (_, _) >] -> find_states_var ic tok
	| [< 'Int (_, _) >] -> find_states_var ic tok
	| [< 'Float (_, _) >] -> find_states_var ic tok
	| [< 'Char (_, _) >] -> find_states_var ic tok
	| [< 'String (_, _) >] -> find_states_var ic tok
	)
      with _ -> []
	
and find_states_var2 ic tok =
    let _ = print_debug ic ("find_states_var2 \n") tok in
      match tok with parser
	  [< 
	    'Ident (_, "States"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
 
	| [< 
	    'Ident (_, "STATES"); 'Kwd (_, "*/"); 
	    vi = parse_C_type_list ic
	  >] 
	  -> vi
	
	| [< 'Ident (_, _) >] -> find_states_var ic tok
	| [< 'Kwd (_, _) >] -> find_states_var ic tok
	| [< 'Int (_, _) >] -> find_states_var ic tok
	| [< 'Float (_, _) >] -> find_states_var ic tok
	| [< 'Char (_, _) >] -> find_states_var ic tok
	| [< 'String (_, _) >] -> find_states_var ic tok
	
and (parse_C_type_list: Lexing.lexbuf -> token Stream.t -> vn_ct list) =
  fun ic tok -> 
    let _ = print_debug ic ("parse_C_type_list \n") tok in
      match (Stream.npeek 1 tok) with
	  [ Kwd (_, "/*") ] -> []
	| [ Kwd (_, "}") ] -> []
	| [ Kwd (_, "#") ] -> []
	| _ -> 
	    (match tok with parser
		 [<
		   vn_ct = parse_one_struct_field ic;
		   'Kwd (_, ";") ; 
		   vars = parse_C_type_list ic 
		 >]
		 -> (vn_ct::vars)
	    )
	  

(****************************************************************************)
let (get_vn_and_ct_list2: file -> 
       vn_ct list * vn_ct list * vn_ct list * vn_ct list) =
  fun file ->
    let file_str = 
      try Util.readfile_rm_crtl_m file 
      with Not_found -> exit 2
    in
    let buff = Lexing.from_string file_str in

    let ic = try open_in file with
	_ ->
	  (
	    print_string ("*** File " ^ file
			  ^ " does not exist. Please check its name.\n");
	    flush stdout;
	    exit 2
	  )
    in

    let vi = find_inputs buff (lexer(Stream.of_channel ic)) in
    let vo = 
      seek_in ic 0;
      find_outputs buff (lexer(Stream.of_channel ic)) 
    in
    let vl = 
      seek_in ic 0;
      find_locals buff (lexer(Stream.of_channel ic)) 
    in
    let vs = 
      seek_in ic 0;
      find_states_var buff (lexer(Stream.of_channel ic)) 
    in
      (vi, vo, vl, vs)


(* exported *)
let (get_vn_and_ct_list: file -> typedef list * vn_ct list * vn_ct list) =
  fun file ->
    try
      let _ = output_string stderr
		("\n parsing " ^ file ^ " (sildex convention) " ^
		 "to get var names and types. \n") ;
	flush stderr
      in
      let (vi, vo, vl1, vl2) = get_vn_and_ct_list2 file in
      let tdl = get_typedef file in

      
      (*
    let p_vn_ct = 
      (fun (vn, ct) -> 
	 print_string ("\n\t * " ^ vn ^ " of type " ^ (ctype_to_string ct))) 
    in
	print_string ("\n INPUTS");
	List.iter p_vn_ct vi;
	print_string ("\n OUTPUTS");
	List.iter p_vn_ct vo;
	print_string ("\n LOCALS");
	List.iter p_vn_ct vl1;
	print_string ("\n STATES");
	List.iter p_vn_ct vl2;
	print_string ("\n TYPEDEF");
	List.iter 
	(fun (n, t) -> 
	print_string ("\n " ^ n ^ " is a typedef for " ^ (ctype_to_string t)))
	tdl;
	print_string ("\n THAT'S ALL FOLKS\n\n");
	flush stdout;
	*)
	(tdl, vi, vo
(* 	   , vl1 @ vl2 *)
	)
    with e ->
      print_string ((Printexc.to_string e) ^ "\n");
      print_string "*** Error when parsing header file with Sildex convention.\n";
      print_string "** Did you really meant to use the Sildex convention?\n";
      flush stdout;
      exit 2
	
	
(****************************************************************************)
