(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: parse_poc.mli
** Main author: jahier@imag.fr
*)

(** Defines primitives for parsing C poc files progmas *)

open Gen_stubs_common

(** [get_vn_and_ct_list file_h] parses poc pragmas in a C header file and
  returns the list of input vars, and the list of output var names and types.

 nb: poc pragmas have the following shape:

 //MODULE: <module name> n m

            (* where [n] is the input var number, and [m] the output var one *)

 //IN:  <C type of the first input var> <a C identifier for the first input var>

 ...

 //IN:  <C type of the nth input var> <a C identifier for the nth input var>

 //OUT: <C type of the first output var> <a C identifier for the first output var>

  ...

 //OUT: <C type of the mth output var> <a C identifier for the mth output var>
*)
val get_vn_and_ct_list : file -> typedef list * vn_ct list * vn_ct list
