(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: parse_poc.ml
** Main author: jahier@imag.fr
**
*)

open Gen_stubs_common

(* XXX Is it really a good idea to use regexp to parse those files ? *)
let reg_typedef = Str.regexp "^typedef"
let reg_blank = Str.regexp " "
let reg_semicol = Str.regexp ";"

(****************************************************************************)
(****************************************************************************)

let reg_MOD = Str.regexp "^//MODULE:"
let reg_IN = Str.regexp "^//IN:"
let reg_OUT = Str.regexp "^//OUT:"
let reg_cr = Str.regexp "\n"

let (find_module_name: string -> module_name * int * int * int) =
  fun str ->
    let beg = Str.search_forward reg_MOD str 0 in
    let mod_name_beg = Str.search_forward reg_blank str beg in
    let mod_name_end = Str.search_forward reg_blank str (mod_name_beg+1) in
    let mod_name = String.sub str (mod_name_beg+1) (mod_name_end - mod_name_beg - 1) in
    let vi_nb_end = Str.search_forward reg_blank str (mod_name_end+1) in
    let vi_nb_str = String.sub str (mod_name_end+1) (vi_nb_end - mod_name_end - 1) in
    let vi_nb =
      try (int_of_string vi_nb_str)
      with _ -> failwith ("*** `" ^ vi_nb_str ^ "'is not an int")
    in
    let vo_nb_end = Str.search_forward reg_cr str (vi_nb_end + 1) in
    let vo_nb_str = String.sub str (vi_nb_end+1) (vo_nb_end - vi_nb_end - 1) in
    let vo_nb =
      try(int_of_string vo_nb_str)
      with _ -> failwith ("*** `" ^  vo_nb_str ^ "'is not an int")
    in
      (mod_name, vi_nb, vo_nb, vo_nb_end)

let rec (find_var_list: Str.regexp -> string -> int -> vn_ct list ->
	   vn_ct list * int) =
  fun reg str sptr vars ->
    try
      let beg =        Str.search_forward reg       str sptr in
      let var_type_b = Str.search_forward reg_blank str beg in
      let var_name_b = Str.search_forward reg_blank str (var_type_b + 1) in
      let var_name_e = Str.search_forward reg_cr    str (var_name_b + 1) in

      let var_type = String.sub str (var_type_b+1) (var_name_b - var_type_b-1) in
      let var_name = String.sub str (var_name_b+1) (var_name_e - var_name_b-1) in
	find_var_list reg str var_name_e ((var_name, Simple var_type)::vars)
    with _  ->

      (* XXX PARSE STRUCTURED TYPES ALSO !!!!!
	nb : pour l'instant, y'en a pas ...
      *)
      (List.rev vars, sptr)


(****************************************************************************)
let (get_vn_and_ct_list2: file -> vn_ct list * vn_ct list) =
  fun file ->
    let str = Util.readfile_rm_crtl_m file in
    let (_, ni, no, str_ptr1) = find_module_name str in
    let (vi, str_ptr2) = find_var_list reg_IN str str_ptr1 [] in
    let (vo, _) = find_var_list reg_OUT str str_ptr2 [] in
      if (List.length vi = ni && List.length vo = no) then
	(vi, vo)
      else
	failwith (
	  "Inconsistent pragmas found in `" ^ file ^
	  "'. The number of variables is wrong: " ^
	  (string_of_int ni)  ^ " and " ^ (string_of_int no)  ^
	  " were declared whereas "  ^ (string_of_int (List.length vi))  ^
	  " and " ^ (string_of_int (List.length vo))  ^ " were counted"
	)

(* exported *)
let (get_vn_and_ct_list: file -> typedef list * vn_ct list * vn_ct list) =
  fun file ->
    try
      let _ = output_string stderr
		("\n parsing " ^ file ^ " (poc convention) " ^
		 "to get var names and types. \n") ;
	flush stderr
      in
      let (sut_vi, sut_vo) = get_vn_and_ct_list2 file in
      let tdl = get_typedef file in
	(tdl, sut_vi, sut_vo)
    with _ ->
      print_string "*** Error when parsing header file with verimag (poc) convention.\n";
      print_string "** Did you really meant to use the verimag convention?\n";
      flush stdout;
      exit 2
	
(****************************************************************************)
