(* Time-stamp: <modified the 05/07/2018 (at 14:20) by Erwan Jahier> *)
(**********************************************************************************)
type vars = (string * Data.t) list

let (var_to_var_pair: Exp.var -> string * Data.t) =
  fun v -> Var.name v, Type.to_data_t (Var.typ v)

let (to_subst_list : (string * Data.t) list -> Value.OfIdent.t -> Data.subst list) =
  fun var_decl vals -> 
    try List.map (fun (n,_) -> n, Value.to_data_val (Value.OfIdent.get vals n)) var_decl
    with Not_found -> assert false

(* ditto, but without taking care of variable order *)
let (from_vals : Value.OfIdent.t -> Data.subst list) = fun vals -> 
  Value.OfIdent.fold (fun id v acc -> (id,Value.to_data_val v)::acc) vals []

let (to_vals : Data.subst list -> Value.OfIdent.t) =
  List.fold_left
    (fun acc (n,v) -> Value.OfIdent.add acc (n, Value.from_data_val v))
    Value.OfIdent.empty

open RdbgPlugin
type ctx = Event.t
type e = Event.t

let make argv =
  let opt = MainArg.parse argv in
  let prog = MainArg.infile opt
  and node = MainArg.main_node opt
  in
  let seed = MainArg.seed opt in
  let lut_mach = LutExe.make opt prog node in
  let lut_in  = List.map var_to_var_pair (LutExe.in_var_list  lut_mach) in 
  let lut_out = List.map var_to_var_pair (LutExe.out_var_list lut_mach) in 
  let lut_memories =
      (*     if LtopArg.args.LtopArg.delay_env_outputs then *)
      (*       LutExe.get_init_pres lut_mach *)
      (*     else *)
    Value.OfIdent.empty
  in
  let ctrl_state = ref (LutExe.get_init_state lut_mach) in
  let data_state = ref
    { LutExe.ins = Value.OfIdent.empty;
      LutExe.outs = lut_memories;
      LutExe.mems = LutExe.get_init_pres lut_mach
    }
  in
  let lut_step sl =
    let _ = data_state := { !data_state with LutExe.ins = to_vals sl } in
    let new_cs, new_ds =  LutExe.step lut_mach !ctrl_state !data_state in
    ctrl_state := new_cs;
    data_state := new_ds;
    to_subst_list lut_out new_ds.LutExe.outs
  in
  let (lut_step_dbg: 
         Data.subst list -> ctx ->       
       (Data.subst list -> ctx -> Event.t) -> Event.t) =
    fun sl ctx cont -> 
      let cont_lut_step ctx = 
        fun new_cs new_ds -> 
          ctrl_state := new_cs;
          data_state := new_ds;
          cont (to_subst_list lut_out new_ds.LutExe.outs) ctx
      in
      data_state := { !data_state with LutExe.ins = to_vals sl };
        (* { (* XXX l'enlever quand j'aurais trouvé le bon endroit dans lutExe ?? *)  *)
        (*           Event.step = ctx.Event.ctx_step; *)
        (*           Event.kind = "lutin_step prog='" ^ (String.concat "," prog) ^  *)
        (*             "' node ='" ^ node ^ "' \n dump expr =" ^ *)
        (*             (LutExe.string_of_control_state !ctrl_state) ^ " \n stack : "  *)
        (*             (*           ^ *) *)
        (*             (*           (CoIdent.string_of_src_stack ()) *) *)
        (*           ; *)
        (*           Event.data = ctx.Event.ctx_data; *)
        (*           Event.next = (fun () ->  *)
      LutExe.step_ldbg ctx node lut_mach !ctrl_state !data_state cont_lut_step
  (*           Event.terminate = ctx.Event.ctx_terminate; *)
  (*         } *)
  in
  let mems_in = 
    List.fold_left
      (fun acc (vn,_vt) -> 
        try 
          let v = Value.OfIdent.get lut_memories vn in
          (vn, Value.to_data_val v)::acc
        with Not_found -> acc
      )
      []
      lut_in
  in
  let mems_out = 
    List.fold_left
      (fun acc (vn,_vt) -> 
        try 
          let v = Value.OfIdent.get lut_memories vn in
          (vn, Value.to_data_val v)::acc
        with Not_found -> acc
      )
      []
      lut_out
  in
  let argv_list = Array.to_list argv in 
  let argv_str = String.concat " " argv_list in
  let id =
    if List.mem "-seed" argv_list then argv_str else
      argv_str ^ " -seed " ^ (string_of_int seed)
  in
  let version = Printf.sprintf "with lutin Version %s (\"%s\")" Version.str Version.sha in
  {
    id = Printf.sprintf "%s (%s)" id version;
    inputs = lut_in;
    outputs= lut_out;
    reset = (fun () -> (
          ctrl_state := (LutExe.get_init_state lut_mach);
          data_state := 
            { LutExe.ins = Value.OfIdent.empty;
              LutExe.outs = lut_memories;
              LutExe.mems = LutExe.get_init_pres lut_mach
            }
        ));
    kill=(fun _ -> ());
    init_inputs=mems_in;
    init_outputs=mems_out;
    step=lut_step;     
    step_dbg=lut_step_dbg;
  }


  

