#include <stdio.h>
#include <string.h>

// #include <caml/mlvalues.h>
// #include <caml/callback.h>

#ifdef WIN32
#define EXPORT __declspec(dllexport)
#else
#define EXPORT
#endif

/* ********************************************************************** */
/* Types */
/* ********************************************************************** */

typedef int process_nb;

/** To indicate whether the point used to perform the step is
    drawn inside, at edges, or at vertices of the convex hull of
    numeric solutions; the step mode is used iff at least one 
    controllable variable is numeric.  
    
    The default step mode is StepInside.
*/
typedef enum step_mode { step_inside, step_edge, step_vertex } step_mode;


/* ********************************************************************** */
/* Initialisation of Caml runtime */
/* ********************************************************************** */

/** Call this function exactly once */
EXPORT void lutin_caml_init();


/* ********************************************************************** */
/* Create/Kill a Lutin process */
/* ********************************************************************** */

EXPORT process_nb make(const char * pre_processor, const char * filename);

// To be called before make_lutin
EXPORT void add_lutin_lib(const char * libname);

EXPORT process_nb make_lutin(const char * pre_processor, const char * filename);
EXPORT void kill_process_nb(process_nb lp);


/* ====================================================================== */
/* Set inputs functions */
/* ====================================================================== */

EXPORT void lutin_set_input_bool(process_nb lp, char* vn, int v);
EXPORT void lutin_set_input_int(process_nb lp, char* vn, int v);
EXPORT void lutin_set_input_float(process_nb lp, char* vn, double v);


/* ********************************************************************** */
/* Step function */
/* ********************************************************************** */

EXPORT void lutin_step(process_nb lp, step_mode sm);


/* ====================================================================== */
/* Get outputs functions */
/* ====================================================================== */

EXPORT int lutin_get_output_bool(process_nb lp, char* vn);
EXPORT int lutin_get_output_int(process_nb lp, char* vn);
EXPORT double lutin_get_output_float(process_nb lp, char* vn);


