(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: luc4c.mli
** Author: jahier@imag.fr
*)

(** Lutin C API: defines functions to be used by lut4c_stubs.h/c. *)

(* ********************************************************************** *)
(* Types *)
(* ********************************************************************** *)

(** Lutin or Lucky process *)
type process_nb = int

 
(** To indicate whether the point used to perform the step is
    drawn inside, at edges, or at vertices of the convex hull of
    numeric solutions; the step mode is used iff at least one 
    controllable variable is numeric.  
    
    The default step mode is StepInside.
*)
type step_mode = StepInside | StepEdges | StepVertices
 
(* ********************************************************************** *)
(* Create/Kill a Lutin Process *)
(* ********************************************************************** *)

exception MakeError

(** to be called before make_lutin *)
val add_lutin_lib : string -> unit

val make_lutin : 
  string  -> (** Lutin file name *)
  string  -> (** Main node *)
  process_nb

val kill_process_nb : process_nb -> unit

(* ********************************************************************** *)
(* Step function *)
(* ********************************************************************** *)

val set_input_bool : process_nb -> string -> bool -> unit
val set_input_int : process_nb -> string -> int -> unit
val set_input_float : process_nb -> string -> float -> unit

val step: process_nb -> step_mode -> unit


val get_output_bool : process_nb -> string -> bool
val get_output_int : process_nb -> string -> int
val get_output_float : process_nb -> string -> float



