(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: lustreExp.mli
** Author: jahier@imag.fr
*)

(** Defines the Output of the lustre expression parser as well as the
  typing function. *)


type t =
  | Le_true of  Lexeme.t
  | Le_false of  Lexeme.t
  | Le_infinity of  Lexeme.t
  | Le_iconst of Lexeme.t * int
  | Le_rconst of Lexeme.t * float
  | Le_ident of Lexeme.t * string

  | Le_not of Lexeme.t * t
  | Le_uminus of Lexeme.t * t
  | Le_abs of Lexeme.t * t
  | Le_pre of Lexeme.t * t

  | Le_sum of Lexeme.t * t * t
  | Le_diff of Lexeme.t * t * t
  | Le_prod of Lexeme.t * t * t
  | Le_mod of Lexeme.t * t * t
  | Le_div of Lexeme.t * t * t
  | Le_and of Lexeme.t * t * t
  | Le_or of Lexeme.t * t * t
  | Le_xor of Lexeme.t * t * t
  | Le_impl of Lexeme.t * t * t
  | Le_eq of Lexeme.t * t * t
  | Le_neq of Lexeme.t * t * t
  | Le_sup of Lexeme.t * t * t
  | Le_supeq of Lexeme.t * t * t
  | Le_inf of Lexeme.t * t * t
  | Le_infeq of Lexeme.t * t * t
  | Le_ite of Lexeme.t * t * t * t
  | Le_array of Lexeme.t * t list
  | Le_array_concat of Lexeme.t * t * t
  | Le_array_hat of Lexeme.t * t * t
  | Le_array_access of Lexeme.t * t * t
  | Le_struct of Lexeme.t * (t * t) list
  | Le_struct_access of Lexeme.t * t * t

  | Le_func_call of Lexeme.t * string * t list

(** Output of the lustre expression parser *)


type vut = (Type.structured * Exp.var_tbl) Util.StringMap.t

(** If the var name is a struct, this field ougth to contain
   the corresponding list of leaves atomic variables *)

 
type my_in_channel = { lv_prefix : string ; string : string }


type typedef = (string * Type.t)

val do_type : my_in_channel -> Exp.var_tbl -> vut -> typedef list ->
      Exp.ext_func_tbl -> t -> Exp.var_tbl * Exp.t * Type.t
(** Type lustre expression *)

(** Infer the type a simple formula (no pre, no arrays) that are parsed
 outside the context of Lucky automata (eg, luckyDraw). 

  If there is an ambiguity, variables that are not declared (second param)
  are supposed to be Float (a good idea ??).
*)
val infer_type : t -> Exp.var list -> Exp.t * Exp.var list


val le_to_string : t -> string
