(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** 
**-----------------------------------------------------------------------
**
** File: graphUtil.ml
** Author: jahier@imag.fr
**
** Utilities on graphs 
** 
** Note: I could use ocamlgraph instead.
** 
*)


(** [has_cycle init graph] checks (linear time) if [graph] has any cycle,
    reachable from [init].

    If it has cycles, it return the <<attach node>> of one of them.

    The graph is given under the form of a table that associated to
    each node its list of successors.
 *)
val has_cycle : string -> string list Util.StringMap.t -> string option




type succ_table = string list Util.StringMap.t

(* Topologically sort nodes of a graph that contains no cycle *)
val top_sort : string list -> succ_table -> string list
