(** EXPANSION : main

------------------------------------------------------------

L'expansion consiste essentiellement  construire 3 tables globales
indexes par des ident target :

- Table des variables (support) : elle contient les entres/sorties
  et les locales (cf. exist) remontes au top via un nommage unique.

- Table des alias : associe  des idents cible des expressions algbriques.
    Les idents cible correpondent au instances de macros utilises
    dans le corps du node.

- Table des traces :  chaque trace nomme est associe une expression
  de trace expanse.

- Table des fonctions externes utilisees, pour + tard 

----------------------------------------------------------*)

(** Le type "rsultat d'expansion" est abstrait *)
type t

(** Les paramtres de l'expansion sont :
-------------------------------------------------------
- Le CheckEnv.t qui rsulte du type/binding check.
    Il permet de retrouver le type effectif (smantique)
    de toute expression source et l'info associe  toute
    instance d'identificateur.
-------------------------------------------------------
- Le code source (type Syntaxe.package)
-------------------------------------------------------
- Le node "main" (string)
-------------------------------------------------------
*)
val make : CheckEnv.t -> Syntaxe.package -> string -> t

(** Le rsultat de l'expansion consiste en 3 tables indexes 
    par des idents cibles (CoIdent.t) :
    - Table des variables (support)
    - Table des alias (d'expressions algbriques)
    - + la liste d'alias
    - Table des traces
*)

(** Info et table des variables support
*)
type support_scope

type support_nature =
   Input
|  Output
|  LocalIn
|  LocalOut
and support_info = {
	si_ident : CoIdent.t ;
   si_nature : support_nature ;
   si_type : CkTypeEff.t ;
   si_ref_exp : CoAlgExp.t ;
   si_src : CoIdent.src_stack;
   (* on ne la cre qu' la demande *)
   mutable si_pre_ref_exp : CoAlgExp.t option ;
   si_default : CoAlgExp.t option ;
   si_scope : support_scope option ;
   si_init  : CoAlgExp.t option ;
   si_range  : (CoAlgExp.t *CoAlgExp.t) option ;
}

(* support_info that are actually used in pre's *)
val support_tab : t -> (CoIdent.t, support_info) Hashtbl.t 

(* support_info that are actually used in pre's *)
val support_pres : t -> (CoIdent.t * support_info) list

val input_list : t -> CoIdent.t list
val output_list : t -> CoIdent.t list
val local_in_list : t -> CoIdent.t list
val local_out_list : t -> CoIdent.t list

val ident_space : t -> CoIdent.space


val node_name : t -> string

(** Info et table des alias algbriques *)
type alias_info = {
	ai_type : CkTypeEff.t;
	ai_def_exp : CoAlgExp.t;
	ai_ref_exp : CoAlgExp.t;
	ai_src : CoIdent.src_stack
}

val alias_tab : t -> (CoIdent.t, alias_info) Hashtbl.t
val alias_list : t -> CoIdent.t list

(* Run tab *)
(* not necessary ?
val run_tab : t -> (CoIdent.t, t) Hashtbl.t
*)

val get_run_expanded_code : t -> CoIdent.t -> t

(** Info et table des alias trace *)

type trace_info = {
	ti_def_exp : CoTraceExp.t;
	ti_src : CoIdent.src_stack ;
}

val trace_tab : t -> (CoIdent.t, trace_info) Hashtbl.t

val get_trace_info : t -> CoIdent.t -> trace_info

(** Info et table des externes utilises
	on garde le CkIdentInfo.t tel quel pour
	usage ultrieur (gnration de code)
	N.B. le source est un lexeme
*)

type extern_info = {
   xi_decl : Syntaxe.let_info;
   xi_prof : CkTypeEff.profile;
   xi_src : Lexeme.t
}

val extern_tab : t -> (string, extern_info) Hashtbl.t

(** Identificateur (target) de la trace principale *)
val main_trace : t -> CoIdent.t

(** DUMP pour debug etc. *)
val dump : t -> unit
val dump_src_ctx : t -> string
