(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: env_state.mli
** Author: jahier@imag.fr
*)

(** The environment state.

  Such a state is a structure that contains two parts :
  - a static part ([static_state_fields]), which is set after the lucky files
  parsing, and which never changes after
  - a dynamic part ([dynamic_state_fields]), which changes after each step.

*)


(** The dynamic part changes at each cycle. *)
type dynamic_state_fields = {
  memory  : Var.subst list;
  ctrl_state : Prog.ctrl_state list;
  input : Var.subst list;
  verbose : int
}


type t = {
  d : dynamic_state_fields ;
  s : Prog.t
}

(** [make pp_opt files] return the initial state of the list of
    nondet reactives machines in file. *)
val make : string option -> string list -> t


(**/**)

(** outputs various statistic about the size of env_state tables *)
(* val dump_env_state_stat : out_channel -> unit *)


val print_mem : t -> unit
