(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: env_state.ml
** Author: jahier@imag.fr
*)

open Util
open List
open Exp


(****************************************************************************)


type dynamic_state_fields = {
  memory  : Var.subst list;
  ctrl_state : Prog.ctrl_state list;
  input : Var.subst list;
  verbose : int
}

type t = {
  d : dynamic_state_fields ;
  s : Prog.t
}

(* Exported *)
let rec (make : string option -> string list -> t) =
  fun pp_opt files ->
    (* XXX Call LutProg.make here for .lut files *)
    let prog =  Prog.make pp_opt files in
      {
	s = prog;
	d = 
	 {
	   memory = [];
	   ctrl_state = prog.initial_ctrl_state;
	   input = [];
	   verbose = 0
	 }
      }



let (print_mem : t -> unit) = 
  fun s -> 
    print_string "*** memories:\n";
    Var.print_subst_list s.d.memory stdout;
    flush stdout
  

(****************************************************************************)

(****************************************************************************)
(* Exported *)

(*
  let print_var var =
      let max1str = match (Var.max var) with
	  Some(Numer(Ival(x)))  -> string_of_int x
	| Some(Numer(Fval(x)))  -> string_of_float x
	| None -> "None"
      and min1str = match (Var.min var) with
	  Some(Numer(Ival(x)))  -> string_of_int x
	| Some(Numer(Fval(x)))  -> string_of_float x
	| None -> "None"
      in
	print_string (
	  "  " ^ (Var.name var) ^ ":" ^
	  " min = " ^ (min1str) ^ " ;  max " ^ (max1str))
    in
    print_string ("\n output: " );
    List.iter (print_var) ( state.s.out_vars);

    print_string ("\n Numeric: " );
    List.iter
      ( fun l ->
	  (List.iter (fun v -> print_var v ; print_string ":") l);
	  print_string "\n"
      )
      (state.s.num_vars_to_gen);

    print_string ("\n outputvarnames: " );
    List.iter
      ( fun l ->
	  (List.iter (fun v -> print_string v ; print_string ":") l);
	  print_string "\n"
      )
      (state.s.output_var_names );



    flush stdout;



let (dump_env_state_stat : out_channel -> unit) =
  fun res ->
    let (size_str : ('a, 'b) Graph.t -> string) =
      fun g ->
	let (n1, n2, n3) = Graph.size g in
	  (
	    "table size = " ^ (string_of_int n1) ^
	    ", node nb = " ^ (string_of_int n2) ^
	    ", trans nb = " ^ (string_of_int n3)
	  )
    in
    let dump x = output_string res x in
      dump "***************************************************************\n";
      dump "******************* A few statistics ... **********************\n";
(*       dump ("*** pre var names: " ^  *)
(* 	    (fold_left (fun acc s -> acc ^ ", " ^ s) "" env_state.pre_var_names)); *)
      dump "\n";

      dump ("*** output var names: " ^
	    (fold_left
	       (fun acc var ->
		  acc ^ ", " ^ (Var.name var) ^ ":" ^
		  (Type.to_string (Var.typ var)))
	       "" env_state.output_vars));
      dump "\n";

      dump ("*** node_to_file_name:" ^
	    (string_of_int (hashtbl_size env_state.node_to_file_name)));
      dump "\n";

(*       dump ("*** linear_constraint_to_index:" ^  *)
(* 	    (string_of_int (hashtbl_size env_state.linear_constraint_to_index))); *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** index_to_linear_constraint:" ^  *)
(* 	    (string_of_int (hashtbl_size env_state.index_to_linear_constraint)));  *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** global_linear_constraint_to_index:" ^  *)
(* 	    (string_of_int  *)
(* 	       (hashtbl_size env_state.global_linear_constraint_to_index))); *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** index_to_global_linear_constraint:" ^  *)
(* 	    (string_of_int  *)
(* 	       (hashtbl_size env_state.index_to_global_linear_constraint)));  *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** cpt_index:" ^  *)
(* 	    (string_of_int env_state.index_cpt));  *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** free_index_list: " ^  *)
(* 	    (fold_left (fun acc i -> acc ^ ", " ^ (string_of_int i)) ""  *)
(* 	       env_state.free_index_list)); *)
(*       dump "\n"; *)
(*  *)
(*  *)
(*  *)
(*       dump ("*** bdd_tbl_global size:" ^  *)
(* 	    (string_of_int (hashtbl_size env_state.bdd_tbl_global)));  *)
(*       dump "\n"; *)
(*  *)
(*       dump ("*** bdd_tbl:" ^  *)
(* 	    (string_of_int (hashtbl_size env_state.bdd_tbl)));  *)
(*       dump "\n"; *)

(*       dump ("*** snt:" ^  *)
(* 	    (string_of_int (hashtbl_size env_state.snt)));  *)
(*       dump "\n"; *)

      dump ("*** graph:" ^ (size_str env_state.graph));
      dump "\n";

      dump "\n";



(*       dump "*** pre variables:"; *)
(*       Var.print_subst_list env_state.pre stderr; *)

(*       dump "*** input variables:";  *)
(*       Var.print_env_in env_state.input stderr;  *)
(*   *)
(*       dump "*** output variables:";  *)
(*       Var.print_env_out env_state.output stderr;  *)
(*   *)
(*       dump "*** local variables:";  *)
(*       Var.print_env_loc env_state.local stderr;  *)

      dump "\n"

*)
