(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: command_line.mli
** Main author: jahier@imag.fr
*)

(** Handles everything that is related to command line lurette calls:
 printing lurette usage message, handling command line options, etc.
*)

open Lucky

type optionsT = {
  mutable step_by_step : int option ;
  mutable display_local_var : bool ;
  mutable display_sim2chro : bool ;
(*   mutable cudd_heap_init : int ; *)
  mutable user_seed : int option ;
  mutable verb : int ;
  mutable show_step : bool ;
  mutable help : bool ;
  mutable output : string ;
  mutable draw_all_formula : bool;
  mutable draw_all_vertices : bool;
  mutable compute_volume : bool;
  mutable step_mode : Lucky.step_mode;
  mutable luciole_mode : bool;
  mutable oracle : bool ;
  mutable pp : string option ;
  mutable scade_gui : bool;
  mutable is_reactive : bool;
  mutable stdin : bool;
  mutable tmp_dir : string;
}

val usage : string
(** Usage message to be printed if an error occur when lurette is called. *)

val cmd_line_string_to_int : string -> string -> int
(** [cmd_line_string_to_int str errmsg] converts a string (of the
 command line) into an integer, and prints [errmsg] before aborting if
 the convertion failed.
*)

type cmd_line_optionT =
    Step | NoStep | Help
  | DisplayLocalVar | NoDisplayLocalVar
  | Sim2chro | NoSim2chro
(*   | CuddHeapInit  *)
  | AllVertices | AllFormula
  | Seed | Precision | NoOracle | Verbose | ShowStep | Output
  | ComputeVolume | StepInside | StepEdges | StepVertices | Stdin | PP
  | Reactive | ScadeGui | TmpDir

val string_to_option: (string * cmd_line_optionT) list
(** Mapping from options string (e.g., "--no-step") to the cmd_line_optionT
  type. *)
