(*-----------------------------------------------------------------------
 ** Copyright (C) - Verimag.
 ** This file may only be copied under the terms of the GNU Library General
 ** Public License
 **-----------------------------------------------------------------------
 **
 ** File: bddd.mli
 ** Main author: jahier@imag.fr
 *)

(** Bdd Drawer. *)

(** Machinery to perform a draw in a bdd. 

    ZZZ : To be used by Solver only !!
*)

  

val draw_in_bdd : Var.env_in -> Var.env -> int -> string -> Exp.var list ->
  Bdd.t -> Bdd.t -> Var.env * Store.t' * Store.p
  (** [draw_in_bdd memory verbose_level ctx_msg state vars bdd comb]
      returns a draw of the Boolean variables as well as a range based
      and a polyhedron based representation of numeric constraints
      (cf. the [Store] module).
      
      Side effect: this is where the solution number tables is filled in.

      Raises [No_numeric_solution].
  *)

open Sol_nb


val sol_number : Bdd.t -> sol_nb * sol_nb
  (** [sol_number bdd] returns the solution number in the [then] and [else]
    branches of [bdd]. *)

(**/**)


val add_snt_entry : Bdd.t -> sol_nb * sol_nb -> unit
(** mofifies an entry. usefull whenever we realize latter that a bdd
 represents a formula that is unsatifiable for numerical reasons. *)


val init_snt : unit -> unit
val clear_snt : unit -> unit


(** For debugging *)
val bdd_to_int : (Bdd.t, int) Hashtbl.t
