(** COMPILATION/GENERATION D'AUTOMATE : interface
------------------------------------------------------------

La gnration d'automate intervient aprs l'expansion, qui
    a produit les infos suivantes :

	_support_tab :  (CoIdent.t, support_info) Hashtbl.t
	_alias_tab   :  (CoIdent.t, alias_info) Hashtbl.t
	_trace_tab   :  (CoIdent.t, trace_info) Hashtbl.t
	_main_trace  :  CoIdent.t


Les exceptions ont t expanses en place, par des identificateurs
uniques dans le expressions associes. Il n'y a donc pas de table
pour elles.


WARNING: 2011/01/05
Split between (full) construction (AutoGen) and
on the fly exploration (AutoExplore)

----------------------------------------------------------*)

(** le type du rsultat *)
type weightexp = 
|	W_huge 
|	W_exp of CoAlgExp.t

(* obsolete
val algexp_of_weight: weightexp -> CoAlgExp.t
*)

(* gtree -> forme externe des transitions adapte 
	 la gnration de lurette *)

type gtree = string * gtree_node
and gtree_node =
|	GT_leaf of (Guard.t * string)
|	GT_choice of (weightexp option * gtree) list
|	GT_stop of string

val gtree_size : gtree -> int

(* trans -> forme externe des transitions
   (liste de trans) adapte  la gnration de lucky  *)
type trans = {
   src: string;
   wgt: weightexp option; 
   form: Guard.t;
   dest: string;
}  
(** N.b. le CoTraceExp.t est l'expression lutin
    EXPANSEE correspondant  l'tat, c'est pas forcement tres
    lisible => juste pour le debug ... *)
type state_info = 
   SS_stable of CoTraceExp.t
|  SS_transient
|  SS_final of string

(* Abstrait *)
type t

(* data configuration *)
type config

val make_config: string -> config

val source : t -> Expand.t
val init_control : t -> string
val transitions : t -> trans list

(* Explore le sous-graphe du state *)
val config2gtree : t -> config -> gtree
val config2trans : t -> config -> trans list 

(* MUST BE INITIALIZED WITH A FUNCTION :
	CoAlgExp.t -> Exp.t
*)
val init : Expand.t -> t

(* Construit TOUT l'automate *)
val make : Expand.t -> t

val get_state_def : t -> string -> CoTraceExp.t

val get_state_info : t -> string -> state_info 

(* Table des tats connus *)
val states : t -> (string, state_info) Hashtbl.t

val dump : t -> unit

