
open Printf
open Expand


(** Impression des expressions algbriques *)
let print_algexp
	(os : Pervasives.out_channel)
	(e : CoAlgExp.t) =  
(
	(* normalement, la syntaxe Lustre doit passer ??? *)
	CoAlgExp.lus_dumpf os e
)


(** utilitaires *)

let print_header 
    (srcname: string)
    (mnode: string)
    (os : Pervasives.out_channel)
    (auto : AutoGen.t) = 
(
  fprintf os 
    "-- generated by lutin2 %s.%s\n" LutVersion.number LutVersion.release;
  fprintf os 
    "-- file: %s node: %s\n"
    srcname
    (mnode );
  
(*
	fprintf os "\nlibraries {\n";
	fprintf os "   liblutin = \"liblutin\";\n";
	fprintf os "}\n";
	fprintf os "\nfunctions {\n";
	fprintf os "   average_goon : int * int * int -> int : liblutin;\n";
	fprintf os "   average_stop : int * int * int -> int : liblutin;\n";
	fprintf os "   interval_goon : int * int * int -> int : liblutin;\n";
	fprintf os "   interval_stop : int * int * int -> int : liblutin;\n";
	fprintf os "}\n";
*)

)

let make
	(srcname: string)
	(mnode : string)
	(auto : AutoGen.t)
	(os : Pervasives.out_channel) =
(

	(* le source au cas ou ... *)
	let source_code = AutoGen.source auto in

	(*************** EN-TTE ************************************)
	print_header srcname mnode os auto;

	(***********************************************************)
	(*************** FONCTIONS EXTERNES ************************)
	(***********************************************************)
	let etab2prof s xi acc = (
		(s, xi.xi_prof)::acc
	) in
	let xlist = Hashtbl.fold etab2prof 
		(Expand.extern_tab source_code) [] in
	if (xlist = []) then ()
	else (
		fprintf os "\nfunctions {\n";
		let pxd (s, p)	= (
			fprintf os "   %s : %s;\n" s (CkTypeEff.prof_to_string p)
		) in
		List.iter pxd xlist;
		fprintf os "}\n";
	);

	(***********************************************************)
	(*************** VARIABLES *********************************)
	(***********************************************************)
	(* pour les dumps des vars support *)
	(* Hashtbl.iter (print_support Local) (Expand.support_tab source_code); *)
	let print_support nme = (
		let info = Util.hfind (Expand.support_tab source_code) nme in
		fprintf os "   %s : %s" 
			(CoIdent.to_string nme)
			(CkTypeEff.to_string info.si_type);
		(* init ? *)
		let _ = match info.si_init with
		|	None -> ()
		|	Some e -> (
			fprintf os " ~init (";
			CoAlgExp.lus_dumpf os e ;
			fprintf os ")"
		) in	
		(* default ? *)
		let _ = match info.si_default with
		|	None -> ()
		|	Some e -> (
			fprintf os " ~default (";
			CoAlgExp.lus_dumpf os e ;
			fprintf os ")"
		) in	
		fprintf os ";\n" 
	) in

	(* pour les dumps de la liste d'alias *)
	let print_alias nme = (
		let info = Util.hfind 
			(Expand.alias_tab source_code) nme in
		fprintf os "   %s : %s"
			(CoIdent.to_string nme)
			(CkTypeEff.to_string info.ai_type);
		fprintf os " ~alias " ;
		print_algexp os info.ai_def_exp;
		fprintf os ";\n"
	) in	
	let print_counter (i: int) = (
		 (* (nme: CoIdent.t) = ( *)
		let nme = CoIdent.of_cpt i in
		fprintf os "   %s : %s" 
			(CoIdent.to_string nme)
			(CkTypeEff.to_string CkTypeEff.integer);
		fprintf os " ~init 0 ";
		fprintf os " ~default (";
		let precpt = CoAlgExp.of_pre nme CkTypeEff.integer in
		CoAlgExp.lus_dumpf os precpt;
		fprintf os ");\n"
	) in
	

	(* ENTRES *)
	fprintf os "inputs {\n" ;
	(* Hashtbl.iter (print_support Input) (Expand.support_tab source_code); *)
	List.iter print_support (Expand.input_list source_code); 
	fprintf os "}\n";

	(* SORTIES *)
	fprintf os "outputs {\n" ;
	(* Hashtbl.iter (print_support Output) (Expand.support_tab source_code); *)
	List.iter print_support (Expand.output_list source_code); 
	fprintf os "}\n";

	(* les LOCALES lucky regroupent : *)
	fprintf os "locals {\n" ;

	(* - les variables support "Local" (de source_code) *)
	(* Hashtbl.iter (print_support Local) (Expand.support_tab source_code); *)
	List.iter print_support (Expand.local_out_list source_code); 

	(* - les alias (de source_code) *)
	List.iter print_alias (Expand.alias_list source_code);

	(* - les compteurs de boucles (de auto)  *)
	(* OBSOLETE List.iter print_counter (AutoGen.counters auto); *)
	for i = 0 to (CoTraceExp.nb_loops () - 1) do
		print_counter i
	done;

	fprintf os "}\n";

	(***********************************************************)
	(*************** ETATS *************************************)
	(***********************************************************)

	let print_state (nme: string) (info: AutoGen.state_info) = (
		match info with
		AutoGen.SS_transient -> (
			fprintf os "   %s : transient;\n" nme
		) |
		AutoGen.SS_final _ -> (
			fprintf os "   %s : final;\n" nme
		) |
		AutoGen.SS_stable tracexp -> (
			fprintf os "   %s : stable;\n" nme
		)
	) in

	fprintf os "nodes {\n" ;
	Hashtbl.iter print_state (AutoGen.states auto) ;
	fprintf os "}\n" ;
	fprintf os "start_node { %s }\n" (AutoGen.init_control auto) ;

	(***********************************************************)
	(*************** TRANSITIONS *******************************)
	(***********************************************************)

	(* on fabrique le "and" et on omprime ... *)
	let print_and_form flist = (
		let rec makeand = ( function
		   	[f] -> f
			|	f::fl -> CoAlgExp.of_and f (makeand fl)
			|	_ -> assert false
		) in
		print_algexp os (makeand flist)
	) in

	let print_trans t = (
		fprintf os "   %s -> %s" t.AutoGen.src t.AutoGen.dest;
		let _ = match t.AutoGen.wgt with
			None -> ()
		|	Some w -> (
			fprintf os "\n      ~weight ";
			match w with
			|	AutoGen.W_huge  -> fprintf os "infinity"
			|	AutoGen.W_exp e -> print_algexp os e ;
		) in
		let fl = Guard.to_exp_list t.AutoGen.form in
		let _ = match fl with
			[] -> ()
		|	flist -> (
			fprintf os "\n      ~cond ";
			print_and_form flist 
		) in
		fprintf os ";\n"
	) in
	fprintf os "transitions {\n" ;
	List.iter print_trans (AutoGen.transitions auto);
	fprintf os "}\n" ;

)
