open LtopArg


let (f : unit -> int) =
  fun () ->
    if args.env = "" then (
      output_string args.ocr ("No environment is provided\n");
      flush args.ocr;
      1
    )
    else      
      let compiler = 
	     if args.sut_compiler = Stdin then ["-stdin"] else []
      in
      let seed_str =
	     match args.seed with
	         None -> []
	       | Some i -> "-seed"::[(string_of_int i)]
      and precision_str = "--precision"::[string_of_int args.precision]
      and compute_volume_str =
	     if (args.compute_volume) then ["--compute-poly-volume"] else []
      and verb_str = ["-v"; (string_of_int (args.verbose))]
      and reactive_str = if (args.reactive) then ["--reactive"] else []
      and show_step_str = if (args.show_step) then ["--show-step"] else []

      and step_mode_str = [step_mode_to_string args.step_mode]
      and inside_nb_str = [string_of_int args.draw_inside]
      and edges_nb_str = [string_of_int args.draw_edges]
      and vertices_nb_str = [string_of_int args.draw_vertices]
      and all_formula_str =
	     if args.all_formula then ["--draw-all-formula"] else []
      and all_vertices_str =
	     if args.all_vertices then ["--draw-all-vertices"] else []
      and orac_str =
	     match args.oracle with
	         None -> ["--no-oracle"]
	       | Some str -> []
      and step_nb_str = [(string_of_int args.step_nb)]
      and draw_nb_str = [(string_of_int args.draw_nb)]
      and outp_str = "-o"::[args.output]
      and step_str = match (args.step_by_step) with Some i ->  ["-s"; string_of_int i] | None ->  []
      and sim2_str =
	     if (args.display_sim2chro) then ["--call-sim2chro"] else ["-ns2c"]
      and dlvr_str =
	     if (args.display_local_var) then ["--display-local-var"] else ["-nlv"]
      and env_str =
	     let lut_list = Util2.string_to_string_list args.env in
          (* 	  List.iter *)
          (* 	    (fun lut -> *)
          (* 	       if lut = "x" then () else *)
          (* 		 if Util.get_extension lut = ".lut" then *)
          (* 		   let file = chop_ext lut in *)
          (* 		     ignore (lutin lut (file ^ ".luc")) *)
          (* 	    ) *)
          (* 	    lut_list; *)
          (* 	  List.map *)
          (* 	    (fun lut -> *)
          (* 	       try let file = chop_ext lut in *)
          (* 		 (file ^ ".luc") *)
          (* 	       with _ -> lut *)
          (* 	    ) *)
	       lut_list

      and pp_str = 
	     match args.pp with 
	         None -> [] | 
	             Some pp -> if pp = "" then [] else ["-pp"; pp]
      and tmp_dir_str = ["--tmp-dir"; args.tmp_dir]
      in	
	     
      let lurette = (Filename.concat args.tmp_dir "lurette") in
      let prefix = Util2.string_to_string_list args.prefix in
	     (*     let lurette = args.tmp_dir ^ "/lurette" in *)
        
      let arg_list0 =
	     List.flatten
	       [
	         prefix;
	         [lurette];
	         step_nb_str ;
	         draw_nb_str ;
	         
	         inside_nb_str;
	         edges_nb_str;
	         vertices_nb_str;
	         step_mode_str;
	         
	         all_formula_str ;
	         all_vertices_str ;

	         compiler;
	         seed_str;
	         precision_str;
	         compute_volume_str;
	         verb_str ;
	         reactive_str ;
	         show_step_str ;
	         orac_str ;
	         outp_str ;
	         step_str ;
	         sim2_str ;
	         dlvr_str ;
	         pp_str ;
            tmp_dir_str ;
	         env_str
	       ]
      in
      let prog = if args.prefix = "" then lurette else List.hd prefix in
      let arg_list = Util.rm "" arg_list0 in
      let arg_array = Array.of_list arg_list in
        
      let pid = 
	     Unix.create_process prog arg_array 
	       (Unix.stdin)
          (* 	  (Unix.stdout) *)
	       (Unix.descr_of_out_channel args.ocr)  
	       (Unix.descr_of_out_channel args.ecr) 
      in
      let _ =
        (* 	output_string args.ecr args_str; *)
	     output_string args.ocr ("\nThe Pid of lurette is " ^ (string_of_int pid) ^ "\n");
	     flush args.ecr;
	     flush args.ocr
      in
      let (_, status) = 
	     try Unix.waitpid [Unix.WUNTRACED] pid with e -> 
	       output_string args.ocr (Printexc.to_string e);
	       flush args.ocr;
	       assert false
      in

	     ( match status with
	         | Unix.WEXITED i -> i
	         | Unix.WSIGNALED i ->
		          output_string args.ecr("lurette was killed by signal nb "
				                           ^ (string_of_int i) ^ ".\n");
		          flush args.ecr;
		          1
	         | Unix.WSTOPPED i ->
		          output_string args.ecr ("lurette was stopped by signal nb "
				                            ^ (string_of_int i) ^ ".\n");
		          flush args.ecr;
		          1
	     )
