

open LtopArg
open Event
let (f : unit -> int) =
  fun () ->
    try
      if args.direct_mode then
        try
          let rec loop_cont e =
            loop_cont (e.next())
          in
            loop_cont (RunDirect.start ())
        with Event.End i -> i
      else
        if 
          let f = Filename.concat args.tmp_dir ("lurette" ^ ExtTools.dot_exe) in
            not (Sys.file_exists f)
        then
          1
        else 
          (match args.sut_compiler with
             | Stdin ->  RunPipe.f () 
             | VerimagV4 
             | VerimagV6 
             | Scade
             | ScadeGUI
             | Sildex
             | Ocamlopt  -> 
                 RunBin.f ()
          ) 
    with
      | Unix.Unix_error(error, name, arg) ->
	       output_string args.ocr
	         ( "*** << " ^
	             (Unix.error_message error) ^
	             " >> in the system call: << " ^ name ^ " " ^ arg ^ " >>\n");
	       flush args.ocr;
	       1
      | e ->
	       output_string args.ocr ("Error in lurette: "^(Printexc.to_string e));
	       flush args.ocr;
	       2
