(* The Ocaml mode allows ocaml-Reactive sut and oracles to be used with Lurette.

An Ocaml-Reactive program is a ocaml program that implement the sut interface.


 *)

open LtopArg


(**************************************************************************)
(* The xlurette ocaml mode requires the "sut.ml" and "oracle.ml" files
   to be defined.  *)

let (get_ocaml_glue : string -> string) =
  fun src_name -> 
    ("
type var_type = string
let init = " ^  src_name ^ ".init
let get_input_var_name_and_type = " ^  src_name ^ ".get_input_var_name_and_type
let get_output_var_name_and_type = " ^  src_name ^ ".get_output_var_name_and_type
let step = " ^  src_name ^ ".step
let trie = " ^  src_name ^ ".step_try
")

let (gen_ocaml_glue : string -> string -> unit) =
  fun user_ocaml_module target -> 
    let code = get_ocaml_glue user_ocaml_module in
    let oc = open_out target in
    let put s = output_string oc s in
	put "(* Automatically generated by xlurette from ";
	put user_ocaml_module;
        put " *)";
        put code;
        close_out oc

let (gen_ocaml_sut : string -> unit) =
  fun user_ocaml_module -> 
    let file = Filename.concat args.tmp_dir "sut.ml" in
      gen_ocaml_glue user_ocaml_module file

let (gen_ocaml_oracle : string -> unit) =
  fun user_ocaml_module -> 
    let file = Filename.concat args.tmp_dir "oracle.ml" in
      gen_ocaml_glue user_ocaml_module file


let (gen_fake_ocaml_oracle : unit -> unit) =
  fun () -> 
    let code = "(* Automatically generated by xlurette  *)
type var_type = string
let init = fun () -> ()
let get_input_var_name_and_type () = []
let get_output_var_name_and_type () = [\"ok\", \"bool\"]
let step _ _ = true, [\"ok\", (Value.B(true))]
let step_try = step
"
    in
    let file = Filename.concat args.tmp_dir "oracle.ml" in
    let oc = open_out file in
      output_string oc code;
      close_out oc
