(* 
   Various functions that launches reactive programs. Basically,
   from a reactive program file (e.g., in lustre), it returns
   - The program I/O names and types 
   - a "terminate gently" function 
   - a step function

   Currently implemented with pipes and forks, but could (should!)be
   compiled and dynamically linked !! 

   Should I use functors instead ???
*)



(** [make_ec ec_file.ec] handles ec programs (expanded code coming from
    Verimag lustre compilers. 

    Raises Failure of string if something bas happens.
*)
val make_ec : string -> RdbgPlugin.t

(* [make_ec_exe ec_file.ec] supposes that ec_file.ec has already been compiled
   into an executable that is named ec_file.
*)
val make_ec_exe : string -> RdbgPlugin.t
(** [make_v6 file node] handles Verimag/Lustre v6 programs 

    Raises Failure of string if something bas happens.
*)
val make_v6 : string -> string -> RdbgPlugin.t

val make_v4 : string -> string -> RdbgPlugin.t

(** [make_socket sock_addr port]

    Take a socket address and a socket port, connect to it. This socket
    is supposed to read and write information using the RIF.

    Raises Failure of string if something bas happens.

    The process that feeds the other side of the socket is supposed 
    to stop if it receives "#quit".
*)
val make_socket : string -> int -> RdbgPlugin.t

val make_socket_init : string -> int -> RdbgPlugin.t

(* var name and var type list *)
type vars = (string * Data.t) list
(** [make_luciole dro_file inputs outputs] 

   fails if dro_file does not exists, or if its interface is not
   compatible with inputs and outputs
*)
val make_luciole : string -> vars -> vars ->
  (string -> unit) * (Data.subst list -> Data.subst list)

(**/**)
val debug : bool ref
