(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: gen_stubs_poc.ml
** Author: jahier@imag.fr
**
*)
open List
open Gen_stubs_common
open Type

(****************************************************************************)

(* exported *)
let (go: module_name -> string -> typedef list -> vn_ct list -> vn_ct list ->
      unit) =
  fun mod_name str tdl vi vo ->
    let oc = open_out (str ^ ".c.new") in
    let put s = output_string oc s in

    let vn_lt_in =
      List.map (fun (vn, ct) -> (vn, c_type_to_lucky_type tdl ct)) vi
    and vn_lt_out =
      List.map (fun (vn, ct) -> (vn, c_type_to_lucky_type tdl ct)) vo
    in



    (*
     ** Compiler directive
     *)
    let _ =
      put ("// Automatically generated from " ^ mod_name ^
	          ".h by bin/gen_stubs (poc).\n" ^
	          "#include <stdlib.h>\n" ^
	          "#include <stdio.h> \n" ^
	          "#include <ocaml2c.h>\n" ^
	          "#include \"" ^ mod_name ^ ".h\" \n" ^
	          " \n") ;

      (*
       ** type definition of values
       *)
      put "typedef int boolean;\n" ;
      put "\n" ;


      (*
       ** variable declarations
       *)

      List.iter (fun (v, ct) ->
		             put ("static " ^ (ctype_to_string ct) ^ "\t" ^ v ^ ";\n")) vi;
      List.iter (fun (v, ct) ->
		             put ("static " ^ (ctype_to_string ct) ^ "\t" ^ v ^ ";\n")) vo ;

      put ("static struct " ^ mod_name ^ "_ctx *prg; \n") ;
      put ("static struct " ^ mod_name ^ "_ctx *prg_copy; \n") ;
      put "\n" ;


      (*
       ** Program state initialisation
       *)
      put "// Program state initialisation \n" ;
      put ("void " ^ str ^ "_init() \n{\n" ^
		       "  prg = " ^ mod_name ^ "_new_ctx(NULL); \n") ;
      put ("  prg_copy = " ^ mod_name ^ "_new_ctx(NULL); \n}\n") ;
      put "\n" ;

      put "\n" ;


      (*
       ** Save and restore the state  
       *)

      put " // Save and restore the state  \n";
      put ("void " ^ str ^ "_save_state ()\n{\n");
      put ("  " ^ mod_name ^ "_copy_ctx(prg_copy, prg);\n") ;
      put "}\n";

      put ("void " ^ str ^ "_restore_state ()\n{\n");
      put ("  " ^ mod_name ^ "_copy_ctx(prg, prg_copy);\n") ;
      put "}\n\n";


      (*
       ** Output procedures
       *)
      put "// Output procedures (get the output values) \n" ;
      List.iter
	     (fun (v, t) ->
           put ("void " ^ mod_name ^ "_O_" ^ v ^ "(void *client_data, " ^
		            (ctype_to_string t) ^
		            " " ^ v ^ "copy) \n{\n" ^
		            "  " ^ v ^ " = " ^ v ^ "copy ; \n}\n\n")
	     )
	     vo ;


      (*
       ** Set and get int values from caml
       *)
      put "\n" ;
      put "// set int values \n" ;
      put ("void " ^ str ^ "_set_val_int(int arg_nb, int vali)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT ->
		            put ("  case " ^ (string_of_int i) ^ ":\n    ") ;
		            put (mod_name ^ "_I_" ^ v ^ "(prg, vali);\n");
		            put "    break;\n";
	           | FloatT -> ()
	           | BoolT -> ()
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vi
    in
    let _ =
      put "  default : \n    printf(\"Unexpected type in set_val_int.\");\n";
      put "    printf(\" The %i nth input arg is not an integer \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;



      put "\n" ;
      put "// get int values \n" ;
      put ("int " ^ str ^ "_get_val_int(int arg_nb)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT ->
		            put ("\n    case " ^ (string_of_int i) ^
		                   ": return " ^ v ^ ";\n");
		            put "    break;\n";
	           | FloatT -> ()
	           | BoolT -> ()
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vo
    in
    let _ =
      put "  default :\n    printf(\"Unexpected type in get_val_int\");\n";
      put "    printf(\". The %i nth output arg is not an integer \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;

      (*
       ** Set and get float values from caml
       *)
      put "\n" ;
      put "// set float values \n" ;
      put ("void " ^ str ^ "_set_val_float(int arg_nb, double valf)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT -> ()
	           | FloatT ->
		            put ("\n    case " ^ (string_of_int i) ^ ": ") ;
		            put (mod_name ^ "_I_" ^ v ^ "(prg, (_real) valf);\n");
		            put "    break;\n";
	           | BoolT -> ()
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vi
    in
    let _ =
      put "  default : \n    printf(\"Unexpected type in set_val_float\");\n";
      put "    printf(\". The %i nth input arg is not a float \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;



      put "\n" ;
      put "// get float values \n" ;
      put ("double " ^ str ^ "_get_val_float(int arg_nb)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT -> ()
	           | FloatT ->
		            put ("\n    case " ^ (string_of_int i) ^
		                   ": return (double) " ^ v ^ ";\n");
		            put "    break;\n";
	           | BoolT -> ()
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vo
    in
    let _ =
      put "  default :\n    printf(\"Unexpected type in get_val_float\");\n";
      put "    printf(\". The %i nth output arg is not a float \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;

      (*
       ** Set and get bool values from caml
       *)
      put "\n" ;
      put "// set bool values \n" ;
      put ("void " ^ str ^ "_set_val_bool(int arg_nb, boolean valb)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT -> ()
	           | FloatT -> ()
	           | BoolT ->
		            put ("\n    case " ^ (string_of_int i) ^ ": ") ;
		            put (mod_name ^ "_I_" ^ v ^ "(prg, valb);\n");
		            put "    break;\n";
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vi
    in
    let _ =
      put "  default : \n    printf(\"Unexpected type in set_val_bool\");\n";
      put "    printf(\". The %i nth input arg is not a Boolean \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;



      put "\n" ;
      put "// get bool values \n" ;
      put ("boolean " ^ str ^ "_get_val_bool(int arg_nb)\n{\n");
      put "  switch (arg_nb){\n";
    in
    let _ =
      List.fold_left
	     (fun i (v, ct) ->
	        (match (c_type_to_lucky_type tdl ct) with
		          IntT -> ()
	           | FloatT -> ()
	           | BoolT ->
		            put ("\n    case " ^ (string_of_int i) ^
		                   ": return " ^ v ^ ";\n");
		            put "    break;\n";
	           | UT xxx ->
		            assert false
	        );
	        (i+1)
	     )
	     0
	     vo
    in
    let _ =
      put "  default :\n    printf(\"Unexpected type in get_val_bool\");\n";
      put "    printf(\". The %i nth output arg is not a Boolean \", arg_nb);\n";
      put "    exit(2);\n  }\n";
      put "}\n" ;


      (*
       ** Step
       *)
      put "\n" ;
      put "// Step \n" ;
      (* Function header *)
      put ("void " ^ str ^ "_step(void) \n{\n");

      put ("  " ^ mod_name ^ "_step(prg);\n") ;
      put "}\n" ;



      (*
       ** Variable number
       *)

      put "\n\n// The 2 following functions return variable numbers \n";
      put ("int " ^ str ^ "_input_arg_nb(void) \n{\n") ;
      put ("   return " ^ (string_of_int (List.length vi)) ^ ";\n");
      put "}\n\n" ;

      put ("int " ^ str ^ "_output_arg_nb(void) \n{\n") ;
      put ("   return " ^ (string_of_int (List.length vo)) ^ ";\n");
      put "}\n\n" ;



      (*
       ** Variable names and types lists
       *)
      put "\n\n// The 2 following functions return the list of inputs \n";
      put "// (resp outputs) variable names and types. \n";

      put ("void " ^ str ^ "_input_var_name_and_type_array(") ;
      put ("int n, vnt_type vnta[" ^ (string_of_int (List.length vi)) ^ "])\n{\n");
    in
    let _ =
      List.fold_left
	     (fun i (vn, t) ->
	        put ("  vnta[" ^ (string_of_int i) ^ "].var_name = \"" ^ vn ^ "\";\n");
	        put ("  vnta[" ^ (string_of_int i) ^ "].var_type = \"" ^
		            (Type.to_string t) ^ "\";\n");
	        (i+1)
	     )
	     0
	     vn_lt_in
    in
    let _ =
      put "}\n\n" ;

      put ("void " ^ str ^ "_output_var_name_and_type_array(") ;
      put ("int n, vnt_type vnta[" ^ (string_of_int (List.length vo)) ^ "])\n{\n");
    in
    let _ =
      List.fold_left
	     (fun i (vn, t) ->
	        put ("  vnta[" ^ (string_of_int i) ^ "].var_name = \"" ^ vn ^ "\";\n");
	        put ("  vnta[" ^ (string_of_int i) ^ "].var_type = \"" ^
		            (Type.to_string t) ^ "\";\n");
	        (i+1)
	     )
	     0
	     vn_lt_out
    in
      put "}\n\n" ;
	   
      close_out oc
	

(****************************************************************************)

