(*-----------------------------------------------------------------------
** Copyright (C) - Verimag.
** This file may only be copied under the terms of the GNU Library General
** Public License
**-----------------------------------------------------------------------
**
** File: gen_stubs_common.mli
** Main author: jahier@imag.fr
*)

type file = string
type module_name = string
type var_name = string

type c_type =
    Simple of string
  | Array of int * c_type
  | Struct of (string * c_type) list
  | Enum of string list

type vn_ct = var_name * c_type
type fresh_var_name = string
type vn_ct_mlt_fvn = var_name * c_type * Type.t * fresh_var_name

type alias = c_type * c_type

type typedef = string * c_type

(* compiler used to compiler sut and oracles *)
type compiler = VerimagV4 | VerimagV6 | Scade | ScadeGUI | Sildex
val string_to_compiler : string -> compiler
val compiler_to_string : compiler -> string



(** Parsing utilities *)
val debug : bool
val print_genlex_token : MyGenlex.token -> unit
val print_debug : Lexing.lexbuf -> string -> MyGenlex.token Stream.t -> unit
val parse_one_struct_field : Lexing.lexbuf -> MyGenlex.token Stream.t -> vn_ct


(**
 [get_typedef file] reads [file] (a C header file) and searches
 for typedef C expressions and returns the list of (alias_type, C_type)
 found in [file].
*)
val get_typedef : file -> typedef list


(** Translates a C type into the corresponding lucky type, and vice versa *)
val c_type_to_lucky_type : typedef list -> c_type -> Type.t
val lucky_type_to_c_type : Type.t -> c_type


(**
  Formats list of strings. E.g., [format_string_list " * " ["int";
  "bool"; "float"]] returns the string "int * bool * float".
*)
val format_string_list : string -> string list -> string


(**
  [update_file new_file old_file] replaces [old_file] by [new_file] iff
  they are different
*)
val update_file : string -> string -> unit


(* Pretty-printing *)
val ctype_to_string : c_type -> string


(* XXX change its name and dir ??? *)
val c_type_to_scade_type : typedef list -> c_type -> string


(**  
   Parse parameters of the form:
       -inputs i1 bool i2 int -outputs o1 float -name titi 
       -typedef type_struct "{f1:bool; f2:type_enum ; f: int ^ 6}"

  Those parameters are in the array [arg].

  This is used by the scade/lurette gui that knows the var names and types
  of the SUT. It is therefore useless to parse header files or whatever.
  We just give the info in the call.
 *)
val parse_scade_lurette_arg : string array -> 
      typedef list * vn_ct list * vn_ct list * string * string
