(* A set of functions that basically calls external tools via create_process *)

open LtopArg

let lurette_path () =
  try Unix.getenv "LURETTE_PATH"
  with _ ->
    output_string args.ocr "Warning lurettetop: Environment var LURETTE_PATH is unset.\n";
    flush args.ocr;
    ""


let (make : string list) =
  try Util2.string_to_string_list (Unix.getenv "MAKE")
  with _ -> ["make"]

(************************************************************************)

let exe, dot_exe = 
  if Sys.os_type = "Win32" then 
    "_exe", ".exe" 
  else 
    "",""


(************************************************************************)
(* XXX i should use Util.my_create_process  *)
(* use to perform system calls of Lurette utilities *)
let (my_create_process : string -> string list -> in_channel -> out_channel ->
     out_channel -> bool) =
  fun prog arg ic oc ec ->
    try
      let pid =
	     output_string args.ecr "lurettetop launches: ";
	     List.iter (fun x -> output_string args.ecr (x ^ " ")) (prog::arg);
	     output_string args.ecr "\n";
	     flush args.ecr;
	     Unix.create_process prog (Array.of_list (prog::arg)) 
	       (Unix.descr_of_in_channel ic) 
	       (Unix.descr_of_out_channel oc) 
	       (Unix.descr_of_out_channel ec)
      in
      let (_,status) = 
	     try (Unix.waitpid [Unix.WUNTRACED] pid) with _ -> assert false
      in
	   (match status with 
	       Unix.WEXITED i -> 
		      if i = 0 || i = 1 then
		        (output_string ec ("     ... " ^ prog ^ " exited normally.\n");
		         flush ec;
		         true)
		      else
		        (output_string oc ("*** Error: " ^ prog ^ " exited ABnormally (return code=" ^ 
                                    (string_of_int i)^").\n");
		         flush oc;
		         false
		        )
	     |	_ ->
		    output_string oc ("*** Error: " ^ prog ^ " exited ABnormally!\n");
		    flush oc;
		    false
	   )
    with
      | Unix.Unix_error(error, name, arg) -> 
	     let msg = ( "*** << " ^ (Unix.error_message error) ^
	                   " >> in the system call: << " ^ name ^ " " ^ arg ^ " >>\n")
	     in
	     output_string oc msg;
	     flush oc;
	     false 
      | e -> 
	     output_string oc (Printexc.to_string e);
	     flush oc;
	     false

let chop_ext = Util.chop_ext_no_excp
let (empty_a_file : string -> unit) = 
  fun file -> 
    close_out (open_out file)

let (gen_stubs : string -> string -> string -> string -> bool) =
  fun sut sut_node oracle oracle_node ->
      if 
	Sys.file_exists ((chop_ext sut) ^ "_io.c") && 
	args.sut_compiler = Sildex 
      then
	(
	  output_string args.ecr ("Delete " ^ (chop_ext sut) ^  "_io.c\n");
	  flush args.ecr;
	  empty_a_file ((chop_ext sut) ^  "_io.c")
	);
      if 
	Sys.file_exists ((chop_ext oracle) ^ "_io.c") && 
	args.oracle_compiler = Sildex 
      then
	(
	  output_string args.ecr ("Delete " ^ (chop_ext oracle) ^  "_io.c\n");
	  flush args.ecr;
	  empty_a_file ((chop_ext oracle) ^  "_io.c")
	);
      
      my_create_process  ("gen_stubs" ^ exe)
	([ sut; sut_node; (compiler_to_string args.sut_compiler)
	 ] @
	 (if oracle = "" then [] else 
	    [oracle; oracle_node ; (compiler_to_string args.oracle_compiler) ]
	 ) @
	 [args.tmp_dir]
	@ (if (args.sut_compiler<> ScadeGUI) && (args.oracle_compiler <> ScadeGUI) then [] else [(args.root_node) ^ ".h"])
	)
	stdin args.ocr args.ecr 

let (show_luc : string -> bool) =
  fun luc_file ->
    (my_create_process 
       "show_luc"
       (luc_file::(
	       match args.pp with
	           None -> []
	         | Some p -> if p = "" then [] else ["-pp"; p]
	     )
       )
       stdin args.ocr args.ecr 
    )

exception LutinFailure

(* exported *)
let (lutin : string -> string -> bool) =
  fun lutfile outputfile ->
    my_create_process
      "lutin"
      [lutfile; outputfile]
      stdin args.ocr args.ecr
      
(***********************************************************************)
(***********************************************************************)
             
