open LtopArg


(* Under the scade GUI, the file config_types.h is automatically
   generated. Therefore, i mimick that behavior in the Scade  
   non GUI mode. *)
let check_config_types_exist args =
  let dir = args.tmp_dir in
  if 
    args.sut_compiler = Scade 
    && not (Sys.file_exists (Filename.concat dir "config_types.h"))
  then
    let oc = open_out (Filename.concat dir "config_types.h") in
      output_string oc "#define false 0\n";
      output_string oc "#define true 1\n";
      output_string oc "#define bool int\n";
      output_string oc "#define _int int\n";
      output_string oc "#define real double\n";
      flush oc;
      close_out oc

let chop_ext = Util.chop_ext_no_excp

(* XXX bien compliqué tout ca. A reprendre proprement *)
let (f : LtopArg.t -> bool) =
  fun args ->
    if args.sut_compiler = Stdin || args.direct_mode  then true else
      let sut_path = Filename.concat args.sut_dir args.sut in
      let _ =
        check_config_types_exist args;
        output_string args.ecr (
          "... generating lurette" ^ " from " ^ sut_path ^ "\n");
      in
	if not (Sys.file_exists sut_path) then (
	  output_string args.ocr ("\n*** File "^sut_path^" does not exist.\n");
	  flush args.ocr;
	  false
	)
	else (
	  output_string args.ecr "  building lurette ...\n";
	  flush args.ecr;
	  if args.sut = "" then (
	    output_string args.ocr "*** The sut field must be filled in.\n ";
	    flush args.ecr;
	    false
	  )
	  else
	    let (oracle, oracle2, oracle_dir) =
	      match args.oracle
	      with
		| None ->  ( "", "",args.tmp_dir)
		| Some str ->
		    let str2 =
		      if Filename.is_implicit str then
			(* we assume the oracle is in the same dir as the 
			   sut in that case *)
			(Filename.concat args.sut_dir str)
		      else
			str
		    in
		      (str2, str2, args.tmp_dir)
	    in
            let make_rule = "nc" in
	    let make_opt =
	      match (args.sut_compiler, args.oracle_compiler) with
		| Scade, _ -> "scade"
		| VerimagV4, VerimagV6 -> make_rule
		| VerimagV6, VerimagV4 -> make_rule
		| VerimagV6, VerimagV6 -> make_rule
		| VerimagV4, VerimagV4 -> make_rule
                | Ocamlopt, Ocamlopt -> "ocaml"
		| Sildex, VerimagV4 -> "sildex_sut"
		| VerimagV4, Sildex  -> "sildex_oracle"
		| Sildex, Sildex  -> "sildex_both"
		| ScadeGUI, _ -> "lurette"
		| _, ScadeGUI -> assert false
		| _, Scade -> "scade"
		| Stdin, _ -> assert false
		| _, Stdin -> assert false
                | sc,oc -> 
                    
                    assert false
	    in
	      if (oracle2 <> "") && not (Sys.file_exists oracle2) then (
		output_string args.ocr
		  ("\n*** File " ^ oracle2 ^ " does not exist.\n");
		flush args.ocr;
		false
	      )
	      else (
		let sut_node = args.sut_node in
		let oracle_node = args.oracle_node in
                  try
                    let putenv var value =
                      Printf.fprintf args.ecr "%s=%s\n" var value;
                      flush args.ecr;
                      Unix.putenv var value
                    in
		      Unix.chdir args.tmp_dir;
		      putenv "SUT_DIR" args.tmp_dir;
                      if args.sut_compiler = Ocamlopt 
                      then putenv "SUT" args.sut
                      else putenv "SUT" sut_node;  
		      putenv "ENV" args.env;
                      (match args.pp with None -> () | 
                           Some pp -> putenv "PP" ("-pp "^ (pp)));
		      putenv "ORACLE_DIR" oracle_dir;
                      if args.oracle_compiler = Ocamlopt then                          
                        (match args.oracle with
                             None-> ()
                           | Some str -> putenv "ORACLE" str)
                      else
			putenv "ORACLE" oracle_node;

		      putenv "USER_TESTING_DIR" (args.sut_dir);
		      putenv "LURETTE_TMP_DIR" (args.tmp_dir);
                      if args.sut_compiler = Ocamlopt then  (
                        let ocaml_module = 
                          Filename.basename (chop_ext args.sut) in
                        let ocaml_module = String.capitalize ocaml_module in
                          if ocaml_module = "Sut" then 
                            failwith "*** You cannot name your sut 'sut.ml'; please rename it.\n"
                          else
                            Ocaml.gen_ocaml_sut ocaml_module
                      ); 
                      (match args.oracle_compiler, args.oracle with
                         | Ocamlopt, Some oracle ->
                             let ocaml_module = Filename.basename (chop_ext oracle) in
                             let ocaml_module = String.capitalize ocaml_module in
                               if ocaml_module = "Oracle" then
			         failwith 
                                   "*** You cannot name your oracle 'oracle.ml', please rename it.\n"
                               else
                                 Ocaml.gen_ocaml_oracle ocaml_module
                         | Ocamlopt, None -> 
                             Ocaml.gen_fake_ocaml_oracle ()
                         | _,_ -> ()
                      ); 

		      if 
                        if args.sut_compiler <> Ocamlopt then (
			  not (ExtTools.gen_stubs (Filename.concat args.sut_dir args.sut) sut_node
				 (if oracle = "" then "" else oracle)
				 (if oracle = "" then "" else oracle_node)
			      ))
                        else 
                          false
		      then
			false
		      else
			let make = 
			  try Util2.string_to_string_list (Unix.getenv "MAKE")
			  with _ -> 
			    ["make"]
			in
			let makefile = 
			  if args.scade_gui then
			    (Filename.concat args.tmp_dir "Makefile")
			  else
			    (Filename.concat 
			       (Filename.concat (ExtTools.lurette_path()) "lib") 
			       "Makefile.lurette") 
			in
			let make_arg_list = 
			  make @
			    [
			      "-r"; 
			      (* 			  "-C"; *)
			      (* 			  ("\"" ^ (args.tmp_dir) ^ "\""); *)
			      "-f";
			      makefile;
			      make_opt
			    ]

			in
			let make_pid =
			  List.iter 
			    (fun x -> output_string args.ecr (x ^ " ")) make_arg_list;
			  output_string args.ecr "\n";
			  flush args.ecr;
			  Unix.create_process 
			    (List.hd make) 
			    (Array.of_list make_arg_list) 
			    (Unix.stdin)
			    (Unix.descr_of_out_channel args.ecr)
			    (Unix.descr_of_out_channel args.ecr)
			in
			  ignore(Unix.waitpid [Unix.WUNTRACED] make_pid);
			  output_string args.ecr "   ... make ok.\n";
			  flush args.ecr; 
			  true

		  with 		      
		    | Unix.Unix_error(error, name, arg) -> 
			output_string args.ocr 
			  ( "*** << " ^
			      (Unix.error_message error) ^
			      " >> in the system call: << " ^ name ^ " " ^ arg ^ " >>\n");
			flush args.ocr;
			false 

		    | Failure e ->
			output_string args.ocr e ;
			flush args.ocr ;
			false
	      )
	)
