(* Demonstrate the use of of a ocaml programs that calls the lutin
   interpreter via sockets. *)

let rif_oc = open_out "call_foo_via_socket.rif"

let lutin = "/home/jahier/lurette/pre_release/cross-win32/bin/lutin"
let lutin = "lutin"
let call_via_socket = "call-via-socket"

let my_create_process prog args =
    try Unix.create_process prog (Array.of_list args) 
      Unix.stdin Unix.stdout Unix.stderr
    with _ -> print_string ("*** can not find "^prog^" in path.\n");  exit 1

let fork_lutin lut_prog =
  (* Socket administration stuff *)
  let sock_io  = Unix.socket Unix.PF_INET Unix.SOCK_STREAM 0 in
  let sock_addr = 
    let my_entrie_byname =
      try Unix.gethostbyname (Unix.gethostname()) with Not_found -> assert false
    in
      my_entrie_byname.Unix.h_addr_list.(0)
  in
  let socket_port_io = 
    let rec (bind_with_free_port : 
               Unix.file_descr -> Unix.inet_addr -> int -> int -> int) =
      fun s saddr port maxtry ->
        if maxtry = 0 then failwith "socket bind failure" else
	  try Unix.bind s (Unix.ADDR_INET(saddr, port)); port
	  with _ -> bind_with_free_port s saddr (port+1) (maxtry-1) 
    in
     bind_with_free_port sock_io  sock_addr 2000 100 
  in
  let args = [call_via_socket; 
              Unix.string_of_inet_addr sock_addr; 
              string_of_int socket_port_io; lutin; 
              "-seed"; "42";
              lut_prog ] 
  in
  let _pid = my_create_process (List.hd args) args in
  let (sock, _) = Unix.listen sock_io 1; Unix.accept sock_io (* bloquant *) in
  let ic = Unix.in_channel_of_descr sock in
  let oc = Unix.out_channel_of_descr sock in
    ic, oc, sock

(* main *)        
let _ = 
  let ic, oc, sock = fork_lutin "foo.lut" in
    (* Read 2 lines (the interface decl). Mandatory too *)
    output_string rif_oc ((input_line ic) ^ "\n");
    output_string rif_oc ((input_line ic) ^ "\n");
    for i = 1 to 10 do
      let data_in = "42 t 3.14\n" in
      let _ = output_string oc data_in; flush oc; (* put the data on the socket... *) in
      let data_out = input_line ic^"\n"^input_line ic (* ... and read it back! *) in 
        output_string rif_oc ("\n"^data_in ^ "" ^ data_out ^"");
    done;
    flush rif_oc;
    close_out rif_oc;
    Unix.shutdown sock Unix.SHUTDOWN_ALL

