#include <stdio.h>
#include <sys/types.h>


#ifdef _WIN32
  #include <process.h>
#endif

#ifdef _WINSOCK
  #include <windows.h>
  #include <winsock2.h>
  #include <stdio.h>
  #pragma comment(lib, "ws2_32.lib")
#else
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netdb.h>
  #include <string.h> 
#endif

// Demonstrate the use of a C program that calls the lutin interpreter via sockets.


#define MAX_BUFF_SIZE 256

int main()
{
  int lutin_pid,sockfd, newsockfd, portno, clilen, i,n;
  FILE *rif;
  struct sockaddr_in serv_addr, cli_addr;
  char buffer[MAX_BUFF_SIZE];
  char portno_str[10];
  
#ifdef _WINSOCK
  WSADATA WSAData;
  WSAStartup(MAKEWORD(2,0), &WSAData);
#endif

  printf("Starting...\n");  
  rif=fopen("call_foo_via_socket.rif", "w");

  // Socket administration stuff 
  
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) error("opening socket");
  serv_addr.sin_family = AF_INET;
  //  serv_addr.sin_addr.s_addr = ((struct in_addr *)(my_entrie_byname->h_addr))->s_addr;
  serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

  printf("Binding...\n");

  portno = 2000;
  serv_addr.sin_port = htons(portno);
  while (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) ) {
    portno++;
    serv_addr.sin_port = htons(portno);
  };
  
  //itoa(portno, portno_str,10);
  sprintf(portno_str, "%d", portno);

  printf("Forking...%i %s\n",portno,portno_str);
  const char *args[] = { 
    "call-via-socket", "127.0.0.1", portno_str, "lutin", "-seed","42", "foo.lut", "-rif","foo.rif",
    //    "-l", "10",
    //         "-vl","1",
    NULL};
#ifdef _WIN32
  _spawnvp(_P_DETACH,  args[0], args);
#else
  lutin_pid = fork();
  if(lutin_pid == 0) {
    execvp(args[0], args);
    printf("Unknown command\n");
    return 0;
  }
#endif

  printf("Listening...\n");
  listen(sockfd,5);
  clilen = sizeof(cli_addr);
  printf("Accepting...\n");
  newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
  if (newsockfd < 0) error(" on accept");
 
  // read the first two lines
  printf("Reading...(%s)\n",buffer);
  readnf(newsockfd,buffer);
  fprintf(rif, "%s\n",buffer);
  readnf(newsockfd,buffer);
  fprintf(rif, " %s\n",buffer);

  int j, rc;
  int a;
  char b;
  float c;
  
  // ok, let's loop with the lutin process
  for(i=0; i < 100; i++) {    
    printf("Looping...%d\n",i);
    send(newsockfd,"42 t 3.14\n",10,0);
    //readnf(newsockfd,buffer); // step number
    //readnf(newsockfd,buffer); // outs
    bzero(buffer,MAX_BUFF_SIZE);
    rc = 0;
    while (1) {
      rc = recv(newsockfd, buffer, MAX_BUFF_SIZE, 0);
      if (rc > 0) break;
    }
    sscanf(buffer,"#step %d #outs %d %c %f ",&j, &a, &b, &c);
    fprintf(rif,  "#step %d \n42 t 3.14 #outs %d %c %f\n",j,a,b,c);
  }

  printf("Exiting...\n");
  write(newsockfd,"q\n",2);


  close(sockfd);
  close(newsockfd);
  fclose(rif);
#ifdef _WINSOCK
  WSACleanup();
#endif


  return 0;
}


int error(int n, char *msg) 
{
  printf("Error %s",msg);
  return n;  
}

/** 
 * readnf() - reading from a file descriptor but a bit smarter 
**/
int readnf (int fd, char *line)
{
    if (readline(fd, line, MAX_BUFF_SIZE) < 0) return 2; 
    return 0;
}
  
/**
 * readline() - read an entire line from a file descriptor until a newline.
 * functions returns the number of characters read but not including the
 * null character.
**/
int readline(int fd, char *str, int maxlen) 
{
  int n;           /* no. of chars */  
  int readcount;   /* no. characters read */
  char c='a';
  
  for (n = 1; n < maxlen; n++) {
    /* read 1 character at a time */
    //readcount = read(fd, &c, 1); /* store result in readcount */
    readcount = recv(fd, &c, 1, 0);
   
    //    printf("Reading char %c (%i)\n",c,readcount);
    if (readcount == 1) /* 1 char read? */
    {
      *str = c;      /* copy character to buffer */
      str++;         /* increment buffer index */         
      if (c == '\n') /* is it a newline character? */
         break;      /* then exit for loop */
    } 
    else if (readcount == 0) /* no character read? */
    {
      printf("no char read\n");
      if (n == 1)   /* no character read? */
        return (0); /* then return 0 */
      else
        break;      /* else simply exit loop */
    } 
    else {
      printf("error in read\n");
      return (-1); /* error in read() */
    }
  }
  *str=0;       /* null-terminate the buffer */
  return (n);   /* return number of characters read */
} /* readline() */

