open Event;;
open Rdbg;;
open Rdbg_utils;;

ltop "set_seed 1";;

add_rp "sut:lutin:heater.lut:temp" ;;
add_rp "env:lutin:heater.lut:ctrl" ;;

set_sim2chro false;;
set_gnuplot true;;

stl 1000;;

i();;













(* The =Event.t= definition *)
let e = run ();;

let e = e.next();;

print_event e;;














(* Step forward *)
let e = next e;;
let e = nexti e 20;;
let e = stepi e 100;;


(* Conditional breakpoints *)
(* vb "Heat_on" e;; *)

let heat_on e =
  List.mem_assoc "Heat_on" e.data &&
  (vb "Heat_on" e);;


let heat_off e =
  List.mem_assoc "Heat_on" e.data &&
  not (vb "Heat_on" e);;

(* set_sim2chro true;; *)
let e =run ();;
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 
let e = next_cond e heat_off;; 
let e = next_cond e heat_on;; 





(* gdb like Breakpoints *)
reset_rp();add_rp "env:lutin:ex1.lut:main2" ;set_sim2chro false;set_gnuplot false;;
let e = run();;
break "ex1.lut::34" ;;
let e = continue e;;





(*  hooks and custom traces *)
let my_print_event e = 
  match e.kind with
    | Node n -> print_string n.name
    | _  -> ()
;;
del_hooks "print_event";;
add_hooks ("print_event",my_print_event);;
let e = nexti e 20;;
del_hooks "print_event";;

let src = 
  match e.kind with
    | Node {port=Exit(cstr,_,src)}
    | Node {port=Fail(cstr,_,src,_)}  ->
      List.iter (fun si -> print_string si.str) (src());
      explain_failure e
    | _ -> ()
;;



(* Profiler *)
profiler true;;
let e = run();;
show_trace:=false;;
nexti e 1000;;
print_string (dump_profile_info());;



man();;
help "base";;
help "utils";;

help "run";;
apropos "";;
apropos "show";;
help "profiler";;







(* recuperation des valeurs directes (sans passer par vi/vb/vf : string -> int/bool/float *)
open Data
let var_to_string v =
    match v with
     | B true -> "true" 
     | B false -> "false" 
     | I i -> string_of_int i 
     | F f -> string_of_float f 
;;
let get_state st =
  let nl,vl = List.split st in
  let vstrl = List.map var_to_string vl in
  let nl = List.map String.lowercase nl in
  let str =
    "let " ^ (String.concat "," nl) ^ 
    " = " ^ (String.concat "," vstrl) ^ ";;\n"
  in
    print_string (str);
    str
;;

print_string (get_state e.data);;

exit 0
;;
