#include <stdlib.h>
#include <stdio.h> 
#include <sys/types.h>
#include <signal.h>
#include <locale.h>
#ifdef _WINSOCK
  #include <windows.h>
  #include <process.h>
  #pragma comment(lib, "Ws2_32.lib")
#else
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <netdb.h>
#endif
#define MAX_BUFF_SIZE 2048 // To be set with care!!
#define SOCK_ADDR "127.0.0.1"
#define SOCK_PORT 2000
typedef int _bool;
// A little program with 3 inputs, and 3 outputs, that dialogs with lurette on a socket.
int main(){
  int i = 0;
  int rc = 0;
  char buff [MAX_BUFF_SIZE];
  int sock, sockfd, newsockfd, clilen;
  struct sockaddr_in serv_addr, cli_addr;
  // The program Inputs:
  int a;  _bool b;  double c;
  char b_char; // used for reading booleans on the socket
  // The program Outputs:
  int x=0;  _bool y=0;  double z=0.0;
  // Socket administration 
#ifdef _WINSOCK
  WSADATA WSAData;
  WSAStartup(MAKEWORD(2,0), &WSAData);
#endif
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) printf("Error: opening socket");
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr(SOCK_ADDR);
  serv_addr.sin_port = htons(SOCK_PORT);
  if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) ) {
    printf("Error when binding %s:%d\n", SOCK_ADDR, SOCK_PORT); exit(2); 
  } 
  listen(sockfd,5);
  clilen = sizeof(cli_addr);
  newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
  if (newsockfd < 0) printf("Error: on accept");
  sock = newsockfd;
  // Make sure that the program uses a "." for reals, and not a ","
  setlocale(LC_ALL, "English"); 
  // sending I/O declarations
  memset(buff, 0, MAX_BUFF_SIZE);



  sprintf(buff, "@#inputs \nx:int \ny:bool\n z:real \n#@\n"); // multi-line rif decl
  send(sock, buff, (int) strlen(buff),0); 
  sprintf(buff, "#outputs a:int b:bool c:real\n"); // single-line rif decl (just for fun)
  send(sock, buff, (int) strlen(buff),0); 
  for (i=1; i<10; i++){ // The main loop   
    // 1 - Reading inputs
    memset(buff, 0, MAX_BUFF_SIZE);
    rc = recv(sock, buff, MAX_BUFF_SIZE, 0);
    if (rc<0)  { printf("Error: cannot read on socket\n"); exit(2); };
    sscanf(buff, "%d %c %lf", &a, &b_char, &c);
    // Translate char into int
    if ((b_char == '0') || (b_char == 'f') || (b_char == 'F')) b = 0;
    if ((b_char == '1') || (b_char == 't') || (b_char == 'T')) b = 1;
    // 2 - Computing the outputs using the inputs
    x = a+1; if (b) { y = 0; } else { y = 1; }; c = z+0.1;  
    // 3 - Writing outputs 
    memset(buff, 0, MAX_BUFF_SIZE);
    sprintf(buff, "%d %d %lf \n", a, b, c);
    send(sock, buff, (int) strlen(buff),0);    
    // A small debug-printf to see what's going on...
    printf("#step %d \n%d %d %f #outs %d %d %f\n", i, a, b, c, x, y, z);
  }
  sprintf(buff,"#quit\n");
  send(sock, buff, (int) strlen(buff),0);    
  return 0;
} 
