(**************************************************************************)
(* Utilities *)

open Data
let get_float var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (F f) -> f | _ -> 
    Printf.printf "*** error when parsing float\n";
    flush stdout;
    assert false
 
let get_bool var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (B b) -> b | _ -> 
    Printf.printf "*** error when parsing bool\n";
    flush stdout;
    assert false

(**************************************************************************)

let init  _ = ()
let kill  _ = ()

let mems_i = []
let mems_o = []

let (inputs :(string * string) list)  = [ "x", "real"; "y", "real"]
let (outputs :(string * string) list) = [ "a", "real"; "b", "real"]

let (step :  Data.subst list -> Data.subst list) =
  fun sut_outs -> 
    let x = get_float "x" sut_outs
    and y = get_float "y" sut_outs in
    let a = x +. 1.0 and b = y +. 1.0 in
      [("a",F a);("b",F b)]

let dyn_file = (Dynlink.adapt_filename "sut.cmo")
let _ = 
  OcamlRM.add_inputs dyn_file inputs;
  OcamlRM.add_outputs dyn_file outputs;
  OcamlRM.add_kill dyn_file kill;
  OcamlRM.add_step dyn_file step;
  OcamlRM.add_mems dyn_file mems_i mems_o

