

(**************************************************************************)
(* Utilities *)

open Data
let get_float var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (F f) -> f | _ -> 
    Printf.printf "*** error when parsing float\n";
    flush stdout;
    assert false
 
let get_bool var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (B b) -> b | _ -> 
    Printf.printf "*** error when parsing bool\n";
    flush stdout;
    assert false

(**************************************************************************)

let init  _ = ()
let kill  _ = ()
let mems_i = []
let mems_o = []

let (inputs :(string * string) list) = [ "a", "real";  "b", "real"]
let (outputs :(string * string) list) = [ "x", "real"; "y", "real"]

let first_step = ref true
let (step :  Data.subst list -> Data.subst list)=
  fun env_outs -> 
    if !first_step  then  (
      (* ZZZ The env starts, and thus should be able to perform its
         first step wqith no input !!! *)
      first_step := false;
      [("x", F 10.0);("y", F 10.0)]
    )
    else 
      let a = get_float "a" env_outs
      and b = get_float "b" env_outs in
      let x = a +. 1.0 and y = b +. 1.0 in
      [("x",F a);("y",F b)]

let dyn_file = (Dynlink.adapt_filename "env.cmo")

let _ = 
  OcamlRM.add_inputs dyn_file inputs;
  OcamlRM.add_outputs dyn_file outputs;
  OcamlRM.add_kill dyn_file kill;
  OcamlRM.add_step dyn_file step;
  OcamlRM.add_mems dyn_file mems_i mems_o
