

(**************************************************************************)
(* Utilities *)

let draw x y =
(*   if Sys.argv.(3) = "dot" then *)
(*     Graphics.plot (truncate x) (truncate y) *)
(*   else *)
    Graphics.lineto (truncate x) (truncate y)

let zoom = 5.0

open Data
let get_float var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (F f) -> f | _ -> 
    Printf.printf "*** error when parsing float\n";
    flush stdout;
    assert false
 
let get_bool var sol =  
  match (try List.assoc var sol with Not_found -> assert false) 
  with (B b) -> b | _ -> 
    Printf.printf "*** error when parsing bool\n";
    flush stdout;
    assert false


(**************************************************************************)
let _ = 
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "Le trajet de l'ivrogne";  
  Graphics.moveto 100 100
(*   ignore (Graphics.read_key ()) *)
;;

(**************************************************************************)

let init  _ = ()
let kill  _ = ()

type var_type = string

let (inputs :(string * string) list) = [
  "x", "real";  
  "y", "real";  
  "p1", "real";  
  "p2", "real";  
  "p3", "real";  
  "p4", "real"
]

let mems_i = []

let mems_o = [
  "x_min", Data.F 0.0;  "x_max", Data.F 100.0;  
  "y_min", Data.F 0.0;  "y_max", Data.F 100.0
]
  
let (outputs :(string * string) list) = 
  [
    "x_min", "real";  "x_max", "real";  
    "y_min", "real";  "y_max", "real"
  ]

let cross_product(ux,uy,vx,vy)  = (ux*.vy-.uy*.vx);;


let image = ref (Graphics.get_image 0 0 (Graphics.size_x ()) (Graphics.size_y ()))
let foi = float_of_int

let cross_product(ux,uy,vx,vy) = (ux*.vy-.uy*.vx)
let is_inside(px,py,p1x,p1y,p2x,p2y,p3x,p3y,p4x,p4y) = 
  let p1p_x = px-.p1x in
  let p1p_y = py-.p1y in
  let p2p_x = px-.p2x in
  let p2p_y = py-.p2y in
  let p3p_x = px-.p3x in
  let p3p_y = py-.p3y in
  let p4p_x = px-.p4x in
  let p4p_y = py-.p4y in
  let p2p1_x = p1x-.p2x in
  let p2p1_y = p1y-.p2y in
  let p1p4_x = p4x-.p1x in
  let p1p4_y = p4y-.p1y in
  let p4p3_x = p3x-.p4x in
  let p4p3_y = p3y-.p4y in
  let p3p2_x = p2x-.p3x in
  let p3p2_y = p2y-.p3y in
    cross_product(p2p1_x, p2p1_y, p2p_x, p2p_y) > 0.0 &&
    cross_product(p1p4_x, p1p4_y, p1p_x, p1p_y) > 0.0 &&
    cross_product(p4p3_x, p4p3_y, p4p_x, p4p_y) > 0.0 &&
    cross_product(p3p2_x, p3p2_y, p3p_x, p3p_y) > 0.0   
        
let (step :  Data.subst list -> Data.subst list)=
  fun drunk_outs -> 
    let x_min = (F (float_of_int 0))
    and x_max = (F (float_of_int (Graphics.size_x ())))
    and y_min = (F (float_of_int 0))
    and y_max = (F (float_of_int (Graphics.size_y ()))) in
    let bounds = [("x_min", x_min);("x_max",x_max);("y_min",y_min);("y_max",y_max)] in 


    (* Drawing the new point onto the Graphics window *)
    let x = get_float "x" drunk_outs
    and y = get_float "y" drunk_outs
    and p1 = get_float "p1" drunk_outs
    and p2 = get_float "p2" drunk_outs
    and p3 = get_float "p3" drunk_outs
    and p4 = get_float "p4" drunk_outs
    in

    let p1 = truncate p1
    and p2 = truncate p2
    and p3 = truncate p3
    and p4 = truncate p4
    in
    let max_x, max_y =  (Graphics.size_x ()),  (Graphics.size_y ()) in
    let pc p maxi = (p * maxi) / 100 in

    let [(p1x, p1y);
         (p2x, p2y);
         (p3x, p3y);
         (p4x, p4y);
         ] = [(pc p1 max_x, max_y);(max_x,pc p2 max_y);
                      (pc p3 max_x, 0);(0, pc p4 max_y)] 
    in
    let point_list = [(p1x, p1y);
                      (p2x, p2y);
                      (p3x, p3y);
                      (p4x, p4y);
         ]
    in
    let poly = Array.of_list point_list in
      Graphics.draw_image !image 0 0;
	   draw x y; 
      image := Graphics.get_image 0 0 max_x max_y;
      Graphics.set_color (Graphics.rgb 0 0 0);
      Graphics.draw_poly poly;
      if 
        (is_inside(x,y,foi p1x,foi p1y,foi p2x,foi p2y,foi p3x,foi p3y,foi p4x,foi p4y))
      then
        (print_string "inside!\n"; flush stdout)
      else
        (print_string "outside!\n"; flush stdout);

      bounds

let _ = 
  OcamlRM.add_inputs "trace_ivrogne.cmxs" inputs;
  OcamlRM.add_outputs "trace_ivrogne.cmxs" outputs;
  OcamlRM.add_kill "trace_ivrogne.cmxs" kill;
  OcamlRM.add_step "trace_ivrogne.cmxs" step;
  OcamlRM.add_mems "trace_ivrogne.cmxs" mems_i mems_o


