/* LuretteTcl.c : Defines the entry point for the DLL application. */


#include "tcl.h"

static int LuretteCmd(ClientData pClientData, Tcl_Interp* pInterp, int argc, 
		      const char* argv[])
{
  int i;
  
  for (i = 1; i < argc; i++) {
    char bu[80];
    sprintf(bu, "output \"\\targ %d: %s\\n\"", i - 1, argv[i]);
	Tcl_Eval(pInterp, bu);
  }
  return TCL_OK;
}

static void DeleteLuretteProc(ClientData clientData)
{
  Tcl_Interp* pInterp;
  pInterp = (Tcl_Interp*) clientData ;
  Tcl_Eval (pInterp, "LuretteQuit");
}


extern __declspec(dllexport) int Lurettetcl_Init(Tcl_Interp* pInterp)
{
  Tcl_CreateCommand(pInterp, "Lurette", LuretteCmd, (void *) pInterp, 
		    DeleteLuretteProc);
  return TCL_OK;
}


