#
set CVS_ID {$Id: GenMake_l4sim.tcl,v 1.70.6.1 2004/09/10 12:11:45 lee Exp $}
set Makefile Makefile

#
#
#
proc parseExternalSimulationCodeFile {path} {
    set c_files {}
    set c_objects {}
    set c_includes {}
    set c_macros {}

    if { ! [ catch { open $path r } fd ] } {
	set state 0
	while { ! [ eof $fd ]  } {
	    if { -1 != [ gets $fd line ] } {
		switch -regexp $line {
		    "^$" -
		    "^\#.*$"  {
			# skip comments and empty lines
		    }
		    {\[C FILES\]} {
			set state 1
		    }
		    {\[C OBJECTS\]} {
			set state 2
		    }
		    {\[C INCLUDE DIRS\]} {
			set state 3
		    }
		    {\[MACRO FILES\]} {
			set state 4
		    }
		    {\[.*\]} {
			puts "warning: \"$line\": unknown section in file \"$path\""
		    }
		    default {
			switch $state {
			    1 {
				lappend c_files $line
			    }
			    2 {
				lappend c_objects $line
			    }
			    3 {
				lappend c_includes $line
			    }
			    4 {
				lappend c_macros $line
			    }
			    default {
				puts "warning: \"$line\": no match for line  $line"
			    }
			}
		    }
		}
	    }
	}
	close $fd
    } else {
	puts "$fd"
	exit 3
    } 
    return [list $c_files $c_objects $c_includes $c_macros]
}

#
# Computes list of files to compile
#
# List of files is given by file $(NODE)_C.files

proc get_list_cfiles { filename } {
    set list_cfiles ""
    if { [ catch { open $filename r } fd ] } {
	puts "$fd"
	exit 1
    }
    while { ! [ eof $fd ] } {
	if { -1 != [ gets $fd line ] } {
	    if { [ string match "*\.c" "$line" ] && ! [ string match "*_typ\.c" "$line" ] } {
		regsub {\.c} "$line" "" c_file
		lappend list_cfiles ${c_file}
	    }
	}
    }
    close $fd
    return $list_cfiles
}


proc add_include_config_directories { fd_mak config_dir } {
    if { ${config_dir} != "" } {
	# config types directory is specified by the user (option -my_config_dir)
	puts -nonewline $fd_mak "-I\"\$(CONFIG_DIR)\" -I\"\$(INCLUDE_DIR)\" -I\"\$(INCLUDE_LIB_DIR)\" "
    } else {
	# config types directory is the default Config Dir
	# WORKDIR is taken into account for upward compatibility
	puts -nonewline $fd_mak "-I\"\$(WORKDIR)\" -I\"\$(INCLUDE_DIR)\" -I\"\$(INCLUDE_CONFIG_DIR)\" -I\"\$(INCLUDE_LIB_DIR)\" "
    }
}

proc add_external_include_directories { fd_mak src_dir c_include_dirs } {
    foreach c_include $c_include_dirs {
	if {[get_absolute_path [pwd] ${c_include}] != [get_absolute_path [pwd] ${src_dir}]} {
	    puts -nonewline $fd_mak "-I\"$c_include\" "
	}
    }
}

# List of C files
set C_FILES ""
set NODE "$env(NODE)"

set C_FILES [ get_list_cfiles ${NODE}${dotFileExt}.files ]

if { [ llength ${C_FILES} ] == 0 } {
    puts "No C files in file ${NODE}${dotFileExt}.files"
    exit 1
}

#
# Generation of Makefile header
#
if { [ catch { open ${Makefile} w } fd_mak ] } {
	puts "$fd_mak"
	exit 1
}

puts $fd_mak "#"
puts $fd_mak "# generated by GenMake (${CVS_ID})"
set date [ clock format [ clock seconds ] -format "%A, %d %B %Y, %H:%M:%S" ]
puts $fd_mak "# ($date)"
puts $fd_mak "#"
puts $fd_mak ""


# User specified compiler
set cc $env(CC)
puts $fd_mak "CC=$cc"

# Runtime platform
set platform $tcl_platform(platform)

# Generation of compilation options

# Initialisation 
set simCompilerFile [file join $scriptDir "sim_compiler.tcl"]

if { [file exists $simCompilerFile] == 1 } {
    source $simCompilerFile

    set  opt_list [GetOptionsList $cc]

    if { [llength $opt_list] != "$SCCP::nb_parameters" } {
	puts "Invalid parameter list ([llength $opt_list] instead of $SCCP::nb_parameters)"
	error 3
    }

    set CCOMPILER [lindex $opt_list 0]
    set CFLAGS    [lindex $opt_list 1]
    set CFLAGS_0  [lindex $opt_list 2]
    set LINKER    [lindex $opt_list 3]
    set LDFLAGS   [lindex $opt_list 4]
    set LIB_OS    [lindex $opt_list 5]
    set LIB_EXT   [lindex $opt_list 7]

    set V_WHOAMI [TOOLS::internalOsName]
    switch -glob $tcl_platform(os) {
	HP* { 
	    set LINK_FLAG "-o "
	    set TO_OBJ "-o "
	    set OBJ_EXT ".o"
	    append CFLAGS " -DSIM"
	    append CFLAGS_0 " -DSIM"
	    append CFLAGS_1 " -DSIGNAL_RECORD"
	}
	SunOS { 
	    set LINK_FLAG "-o "
	    set TO_OBJ "-o "
	    set OBJ_EXT ".o"
	    append CFLAGS " -DSIM"
	    append CFLAGS_0 " -DSIM"
	    append CFLAGS_1 " -DSIGNAL_RECORD"
	}
	Windows* { 
	    if { $cc == "gcc" } {
		set OBJ_EXT ".o"
		set LINK_FLAG "-o "
		set TO_OBJ "-o "
		append CFLAGS " -DSIM -DBUILD_DLL"
		append CFLAGS_0 " -DSIM"
		append CFLAGS_1 " -DSIGNAL_RECORD"
	    } else {
		set OBJ_EXT ".obj"
		set LINK_FLAG "/out:"
		set TO_OBJ "/Fo"
		append CFLAGS " /D \"SIM\""
		append CFLAGS_0 " /D \"SIM\""
		append CFLAGS_1 " /D \"SIGNAL_RECORD\""
	    }
	}
	default {
	    puts "Operating system not supported ($tcl_platform(os))."
	    exit 1
	}
    }
} else {
    puts "File \"$simCompilerFile\" not found. Execution aborded."
    exit 1
}
createDir ${V_WHOAMI}

set BIN_EXT ".exe"

puts $fd_mak "NODE_NAME= ${NODE}"
puts $fd_mak "TARGET= \$(NODE_NAME)${BIN_EXT}"
# Generation of main node objects localization
puts $fd_mak "# Localization of objects"

puts $fd_mak "NODE_OBJECTS = [file join . ${V_WHOAMI}]"
# Generation of main node sources localization
puts $fd_mak "# Localization of the sources"
puts $fd_mak "NODE_SOURCES = ."
puts $fd_mak "CFLAGS= ${CFLAGS}"
puts $fd_mak "CFLAGS_0= ${CFLAGS_0}"
puts $fd_mak "CFLAGS_1= ${CFLAGS_1}"

puts $fd_mak "LDFLAGS= ${LDFLAGS}"
puts $fd_mak "LINKER= ${LINKER}"

puts $fd_mak ""

puts $fd_mak "WORKDIR=$env(WORKDIR)"

if {$platform == "windows" && $cc == "cl"} {
    puts $fd_mak "BIN_DIR=[compactPath $env(BIN_DIR)]"
    puts $fd_mak "LIB_DIR=[compactPath $env(LIB_DIR)]"
} elseif {$platform == "windows" && $cc == "gcc"} {
    puts $fd_mak "LIB_DIR=[ms_path [compactPath $env(LIB_DIR)]]"
    puts $fd_mak "LIB_DIR2=[treat_white_space_character [compactPath $env(LIB_DIR)]]"
    puts $fd_mak "BIN_DIR=[treat_white_space_character [compactPath $env(BIN_DIR)]]"
} else {
    set LIB_DIR [treat_white_space_character $env(LIB_DIR)]
    set BIN_DIR [treat_white_space_character $env(BIN_DIR)]
    puts $fd_mak "LIB_DIR=[compactPath ${LIB_DIR}]"
    puts $fd_mak "BIN_DIR=[compactPath ${BIN_DIR}]"
}

if { ${CONFIG_TYPE_DIR} != "" } {
    puts $fd_mak "CONFIG_DIR=${CONFIG_TYPE_DIR}"
}
puts $fd_mak "INCLUDE_DIR=[GetIncludeDir]"
puts $fd_mak "INCLUDE_LIB_DIR=[GetIncludeLibDir]"
puts $fd_mak "INCLUDE_CONFIG_DIR=[GetIncludeConfigDir]"
puts $fd_mak ""

puts $fd_mak "LIB_OS= ${LIB_OS}"

#gcc hack
set ext ""

if {$platform == "windows" } {
    if { $cc == "cl"} {
	puts $fd_mak "MEMORIES=\"[file join \$(LIB_DIR) memories.c]\""
	puts $fd_mak "PROXY=\"[file join \$(LIB_DIR) SmuProxy.c]\""
	puts $fd_mak "DEF_FILE=\"[file join \$(LIB_DIR) SmuExport.def]\""
	puts $fd_mak "MAIN=\"[file join \$(LIB_DIR) SmuMainWindows.c]\""
	puts $fd_mak "DEFAULT=\"[file join \$(LIB_DIR) SmuDefaults.c]\""
    } else {
	puts $fd_mak "MEMORIES=\"[ms_path [file join \$(LIB_DIR) memories.c]]\""
	puts $fd_mak "PROXY=\"[ms_path [file join \$(LIB_DIR) SmuProxy.c]]\""
	puts $fd_mak "DEF_FILE=\"[ms_path [file join \$(LIB_DIR) SmuExport.def]]\""
	puts $fd_mak "MAIN=\"[ms_path [file join \$(LIB_DIR) SmuMainWindows.c]]\""
	puts $fd_mak "DEFAULT=\"[ms_path [file join \$(LIB_DIR) SmuDefaults.c]]\""
	set ext 2
	puts $fd_mak "MEMORIES2=[file join \$(LIB_DIR2) memories.c]"
	puts $fd_mak "PROXY2=[file join \$(LIB_DIR2) SmuProxy.c]"
	puts $fd_mak "DEF_FILE2=[file join \$(LIB_DIR2) SmuExport.def]"
	puts $fd_mak "MAIN2=[file join \$(LIB_DIR2) SmuMainWindows.c]"
    }
} else {
    puts $fd_mak "MEMORIES=[file join \$(LIB_DIR) memories.c]"
    puts $fd_mak "PROXY=[file join \$(LIB_DIR) SmuProxy.c]"
    puts $fd_mak "MAIN=[file join \$(LIB_DIR) SmuMainUnix.c]"
    puts $fd_mak "DEFAULT=[file join \$(LIB_DIR) SmuDefaults.c]"
}

#
#
#
set external_c_file_list {}
set external_o_file_list {}
set external_c_include_list {}
#
if { [info exist env(EXTERNAL_SIMULATION_CODE_FILE)] } {
    set ll [parseExternalSimulationCodeFile $env(EXTERNAL_SIMULATION_CODE_FILE)]
    set c_files [lindex $ll 0]
    set o_files [lindex $ll 1]
    set c_includes [lindex $ll 2]

    foreach c_file $c_files {
	set dir_path [file dirname $c_file]
	set base_name [file rootname [file tail $c_file]]
	set abs_path [get_absolute_path $env(WORKDIR) $dir_path]
	lappend external_c_file_list [list $abs_path $base_name]
    }
    
    foreach o_file $o_files {
	set dir_path [file dirname $o_file]
	set base_name [file tail $o_file]
	set abs_path [get_absolute_path $env(WORKDIR) $dir_path]
	lappend external_o_file_list [file join $dir_path $base_name]
    }

    foreach c_include $c_includes {
	set abs_path [get_absolute_path $env(WORKDIR) $c_include]
	lappend external_c_include_list $abs_path
    }
}

# Generation of node objects list
puts -nonewline $fd_mak "NODE_OBJ = "

foreach FILE ${C_FILES} {
    puts $fd_mak " \\"
    puts -nonewline $fd_mak "	[ file join \$(NODE_OBJECTS) ${FILE}${OBJ_EXT} ]"
}

if { [llength $external_c_file_list] > 0} {
    puts $fd_mak " \\"
    puts -nonewline $fd_mak "	\$(EXTERNAL_FUNCTIONS)"
}

#
# memories.c
#
puts $fd_mak " \\"
puts -nonewline $fd_mak "	[ file join \$(NODE_OBJECTS) memories${OBJ_EXT} ]"

#
# SmuProxy.c
#
puts $fd_mak " \\"
puts -nonewline $fd_mak "	[ file join \$(NODE_OBJECTS) SmuProxy${OBJ_EXT} ]"

#
# SmuDefaults.c
#
puts $fd_mak " \\"
puts -nonewline $fd_mak "	[ file join \$(NODE_OBJECTS) SmuDefaults${OBJ_EXT} ]"

#
# init.cpp & main.c
#
foreach o_file $external_o_file_list {
    set dir_name [file dirname $o_file]
    set base_name [file tail $o_file]
    set abs_dir [get_absolute_path $env(WORKDIR) $dir_name]
    set obj_to_link [file join $abs_dir $base_name]
    puts $fd_mak " \\"
    if {$platform == "windows"} {
	puts -nonewline $fd_mak "	\"[ms_path $obj_to_link]\""
    } else {
	# guillemets non supportes par l'outil make (Unix ou Cygwin)
	# on precede les blancs par des backslash
	set obj_to_link [ treat_white_space_character ${obj_to_link} ]
	puts -nonewline $fd_mak "	$obj_to_link "
    }
}

puts $fd_mak ""
puts $fd_mak ""

# Generation of EXTERNAL_FUNCTIONS, if exists
if {[llength $external_c_file_list]>0} {
    puts $fd_mak "# Objects files for external functions"
    puts -nonewline $fd_mak "EXTERNAL_FUNCTIONS ="
    foreach c_file $external_c_file_list {
	set dir_name [lindex $c_file 0]
	set file_name [lindex $c_file 1] 
	set target_obj_dir [file join \$(NODE_OBJECTS) ]

	puts $fd_mak " \\"
	if {$platform == "windows" && $cc == "cl"} {
	    # le path $(OBJECT_fctext) peut contenir des caracteres blancs
	    # on encadre les chaines correspondantes par des guillemets
	    # (supportes par Nmake)
	    puts -nonewline $fd_mak "	\"[ file join $target_obj_dir ${file_name}${OBJ_EXT} ]\""
	} else {
	    # guillemets non supportes par l'outil make (Unix ou Cygwin)
	    # on precede les blancs par des backslash
	    set objfilename [ file join $target_obj_dir ${file_name}${OBJ_EXT} ]
	    set objfilename [ treat_white_space_character $objfilename ]
	    puts -nonewline $fd_mak "	$objfilename"
	}
    }
    puts $fd_mak ""
}

# Generation of the root access of the Makefile
puts $fd_mak ""
puts $fd_mak "all :	\$(TARGET)"
puts $fd_mak ""

if {$platform != "windows" || $cc == "gcc"} {
    puts $fd_mak "clean:"
    puts $fd_mak "	rm -f \$(TARGET) \$(NODE_OBJ) [file join "\$(NODE_OBJECTS)" SmuMainWindows${OBJ_EXT}]"
    puts $fd_mak ""
}



# Generation of the Lurette part

puts $fd_mak "###########################################################"
puts $fd_mak "##"
puts $fd_mak "##  EXECUTABLE GENERATION FOR LURETTE"
puts $fd_mak "##"
puts $fd_mak "###########################################################"
puts $fd_mak ""
puts $fd_mak ""

# SUT, SUT_DIR, ORACLE, ORACLE_DIR, LURETTE_TMP_DIR, 
# and USER_TESTING_DIR are set up by lurettetop.
#
# LURETTE_PATH is set via "set_env_var.bat"

puts $fd_mak "LURETTE_OBJ = \\"
puts $fd_mak "	\$(NODE_OBJ)  \\"
puts $fd_mak "	\$(NODE_OBJECTS)/lurette__sut.o  \\"
puts $fd_mak "	\$(NODE_OBJECTS)/lurette__oracle.o"
puts $fd_mak ""


puts $fd_mak "LURETTE_INCLUDEDIRS =  \\"
puts $fd_mak "	-I\"\$(USER_TESTING_DIR)\" -I\"\$(LURETTE_TMP_DIR)\" -I\"\$(LURETTE_PATH)/include\"  \\"
puts $fd_mak "	-I\".\"  \\"
puts $fd_mak "	-I\"\$(LIB_DIR)\"  \\"
puts $fd_mak "	-I\"\$(WORKDIR)\"  \\"
puts $fd_mak "	-I\"\$(INCLUDE_DIR)\"  \\"
puts $fd_mak "	-I\"\$(INCLUDE_CONFIG_DIR)\"  \\"
puts $fd_mak "	-I\"\$(INCLUDE_LIB_DIR)\" "
puts $fd_mak ""

puts $fd_mak "LURETTE_LIBDIRS =  \\"
puts $fd_mak "	-L\"\$(LURETTE_TMP_DIR)\"  \\"
puts $fd_mak "	-L\"\$(LURETTE_PATH)/lib\"  \\"
puts $fd_mak "	-L\$(NODE_NAME)"
puts $fd_mak ""

puts $fd_mak "LUCKY_LIBS = -I\"\$(LIB_DIR)\\..\\lurette\\include\" -L\"\$(LIB_DIR)\\..\\lurette\\lib\" -lluc4c_nc -llucky_nc -lgmp -lws2_32 -lm -lstdc++"
puts $fd_mak "LURETTE_LIBS = -llurette_nc -llucky_nc -lgmp -lws2_32 -lm -lstdc++"
puts $fd_mak "LURETTE_CFLAGS = -O2 \$(CFLAGS) "
puts $fd_mak ""

puts $fd_mak "\$(NODE_OBJECTS)/lurette__sut.o : lurette__sut.c"
puts $fd_mak "	\$(CC) \$(LURETTE_INCLUDEDIRS) \$(LURETTE_CFLAGS)  \\"
puts $fd_mak "		-c \"\$(LURETTE_TMP_DIR)/lurette__sut.c\" -o $@"
puts $fd_mak ""

puts $fd_mak "\$(NODE_OBJECTS)/lurette__oracle.o : lurette__oracle.c"
puts $fd_mak "	\$(CC) \$(LURETTE_INCLUDEDIRS) \$(LURETTE_CFLAGS)  \\"
puts $fd_mak "		-c \"\$(LURETTE_TMP_DIR)/lurette__oracle.c\" -o $@"
puts $fd_mak ""

puts $fd_mak "lurette: \$(LURETTE_OBJ) \$(NODE_NAME)${BIN_EXT} "
puts $fd_mak "	\$(CC) \$(LURETTE_CFLAGS) \$(LURETTE_INCLUDEDIRS) \\"
puts $fd_mak "  \$(LURETTE_OBJ)  \\"
puts $fd_mak "	\$(LURETTE_LIBDIRS) \\"
puts $fd_mak "  \$(LURETTE_LIBS) \$(LDFLAGS) -o lurette.exe "
puts $fd_mak ""

puts $fd_mak "lurette_clean:"
puts $fd_mak "	del \Q lurette__sut.c lurette__oracle.c lurette.exe " 
puts $fd_mak ""



# Generation of link for main node
puts $fd_mak "###########################################################"
puts $fd_mak "##"
puts $fd_mak "##  EXECUTABLE GENERATION FOR THE MAIN NODE"
puts $fd_mak "##"
puts $fd_mak "###########################################################"

puts $fd_mak ""
if {$platform == "windows" } {
    puts $fd_mak "\$(NODE_NAME)${BIN_EXT}: [file join "\$(NODE_OBJECTS)" SmuMainWindows${OBJ_EXT}] \$(NODE_NAME)_dll${OBJ_EXT} \$(NODE_NAME).dll"
    if { $cc == "gcc"} {
	puts $fd_mak "	\$(LINKER) [file join "\$(NODE_OBJECTS)" SmuMainWindows${OBJ_EXT}] \$(NODE_NAME)_dll${OBJ_EXT} \$(LUCKY_LIBS) \$(LDFLAGS) -L\$(NODE_NAME) ${LINK_FLAG}\$@ \$(LIB_OS)"
    } else {
	puts $fd_mak "	\$(LINKER) [file join "\$(NODE_OBJECTS)" SmuMainWindows${OBJ_EXT}] \$(NODE_NAME)_dll${OBJ_EXT} \$(NODE_NAME)${LIB_EXT} \$(LDFLAGS) ${LINK_FLAG}\$@ \$(LIB_OS)"
    }
} else {
    puts $fd_mak "\$(NODE_NAME)${BIN_EXT}: [file join "\$(NODE_OBJECTS)" SmuMainUnix${OBJ_EXT}] \$(NODE_NAME)_dll${OBJ_EXT} \$(NODE_NAME)${LIB_EXT}"
    puts $fd_mak "	\$(LINKER) [file join "\$(NODE_OBJECTS)" SmuMainUnix${OBJ_EXT}] \$(NODE_NAME)_dll${OBJ_EXT} \$(LIB_OS) \$(LIB_SIM) \$(NODE_NAME)${LIB_EXT} \$(LDFLAGS) ${LINK_FLAG}\$@ "
}
puts $fd_mak ""

if {$platform == "windows" } {
    puts $fd_mak "\$(NODE_NAME).dll : \$(NODE_OBJ) \$(LIB_SIM) \$(DEF_FILE${ext})"
    if { $cc == "gcc"} {
	set DLL_OBJ "\$(LIB_SIM) \$(NODE_OBJ) \$(DLL_RUNTIME)"
	puts $fd_mak "	copy \$(DEF_FILE) . >nul"
	puts $fd_mak "	dllwrap --driver-name=gcc --dllname ${NODE}.dll --def ./SmuExport.def --output-lib=lib${NODE}dll.a ${DLL_OBJ}  \$(LUCKY_LIBS) "
    } else {
	puts $fd_mak "	\$(LINKER) \$(NODE_OBJ) \$(LIB_SIM) \$(LDFLAGS) /dll /pdb:${NODE}.pdb /pdbtype:sept /def:\$(DEF_FILE) /implib:\"\$(NODE_NAME).lib\" ${LINK_FLAG}\$@ \$(LIB_OS)"
    }
} else {
    # Unix
    puts $fd_mak "\$(NODE_NAME)${LIB_EXT} : \$(NODE_OBJ)"
    puts $fd_mak "	ld -G \$(NODE_OBJ) \$(LDFLAGS) \$(LIB_OS) -Bsymbolic -b ${LINK_FLAG}\$@"
}
puts $fd_mak ""

foreach FILE ${C_FILES} {
    puts $fd_mak "[ file join \$(NODE_OBJECTS) ${FILE}${OBJ_EXT} ] : [ file join \$(NODE_SOURCES) ${FILE}.c ]"
    puts -nonewline $fd_mak "	\$(CC) -I\".\" -I\"\$(LIB_DIR)\" "
    add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
    add_external_include_directories $fd_mak [pwd] $external_c_include_list
    if {[regexp {(_interface(_[0-9]+)?)$} ${FILE}] == 1} {
	puts -nonewline $fd_mak "\$(CFLAGS_0) "
    } else {
	puts -nonewline $fd_mak "\$(CFLAGS) "
    }
    puts $fd_mak "-c [ file join \$(NODE_SOURCES) ${FILE}.c ] ${TO_OBJ}\$@"
    puts $fd_mak ""
}

foreach c_file $external_c_file_list {
    set dir_name [lindex $c_file 0]
    set file_name [lindex $c_file 1]
    set target_obj_dir [file join \$(NODE_OBJECTS) ]
 
    if {$platform == "windows"} {
	# le path $(OBJECT_fctext) peut contenir des caracteres blancs
	if {$cc == "cl"} {
	    # on encadre les chaines correspondantes par des guillemets
	    # (supportes par Nmake)
	    puts $fd_mak "\"[ file join ${target_obj_dir} ${file_name}${OBJ_EXT} ]\" : \"[ file join ${dir_name} ${file_name}.c ]\""
	    puts -nonewline $fd_mak "	\$(CC) -I\"\$(NODE_SOURCES)\" -I\"${dir_name}\" -I\"\$(LIB_DIR)\" "
	    add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
	    add_external_include_directories $fd_mak ${dir_name} $external_c_include_list
	    puts -nonewline $fd_mak "\$(CFLAGS) "
	    if {[string match "ssm_main" $file_name]} {
		puts -nonewline $fd_mak "\$(CFLAGS_1) "
	    }
	    puts $fd_mak "-c \"[ file join ${dir_name} ${file_name}.c ]\" ${TO_OBJ}\$@"
	} else {
	    # guillemets non supportes par l'outil make (Unix ou Cygwin)
	    # on precede les blancs par des backslash
	    set cfilename [ file join ${dir_name} ${file_name}.c ]
	    set objfilename [ file join ${target_obj_dir} ${file_name}${OBJ_EXT} ]
	    set cfilename [ treat_white_space_character $cfilename ]
	    set objfilename [ treat_white_space_character $objfilename ]
	    puts $fd_mak "$objfilename : $cfilename"
	    puts -nonewline $fd_mak "	\$(CC) -I\"\$(NODE_SOURCES)\" -I\"${dir_name}\" -I\"\$(LIB_DIR)\" "
	    add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
	    add_external_include_directories $fd_mak ${dir_name} $external_c_include_list
	    puts -nonewline $fd_mak "\$(CFLAGS) "
	    if {[string match "ssm_main" $file_name]} {
		puts -nonewline $fd_mak "\$(CFLAGS_1) "
	    }
	    # blancs pecedes par backslash non supportes
	    set cfilename \"[ms_path [ file join ${dir_name} ${file_name}.c ]]\"
	    puts $fd_mak "-c \"[ file join ${dir_name} ${file_name}.c ]\" ${TO_OBJ}\$@"
	}
    } else {
	# guillemets non supportes par l'outil make (Unix ou Cygwin)
	# on precede les blancs par des backslash
	set cfilename [ file join ${dir_name} ${file_name}.c ]
	set objfilename [ file join ${target_obj_dir} ${file_name}${OBJ_EXT} ]
	set cfilename [ treat_white_space_character $cfilename ]
	set objfilename [ treat_white_space_character $objfilename ]
	puts $fd_mak "$objfilename : $cfilename"
	puts -nonewline $fd_mak "	\$(CC) -I\"\$(NODE_SOURCES)\" -I\"${dir_name}\" -I\"\$(LIB_DIR)\" "
	add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
	add_external_include_directories $fd_mak ${dir_name} $external_c_include_list
	puts -nonewline $fd_mak "\$(CFLAGS) "
	if {[string match "ssm_main" $file_name]} {
	    puts -nonewline $fd_mak "\$(CFLAGS_1) "
	}	
	puts $fd_mak "-c $cfilename ${TO_OBJ}$objfilename"
    }
    puts $fd_mak ""
}

#
# memories.o
#
puts $fd_mak "[ file join \$(NODE_OBJECTS) memories${OBJ_EXT} ]: \$(MEMORIES${ext})"
puts $fd_mak "	\$(CC) \$(CFLAGS) -I\"\$(LIB_DIR)\" -c \$(MEMORIES) ${TO_OBJ}\$@"
puts $fd_mak ""

#
# $(NODE_NAME)_dll${OBJ_EXT}
#
puts $fd_mak "[ file join \$(NODE_OBJECTS) \$(NODE_NAME)_dll${OBJ_EXT} ] : \$(NODE_NAME)_dll.c"
puts $fd_mak "	\$(CC) \$(CFLAGS) -c \$(NODE_NAME)_dll.c ${TO_OBJ}\$@"
puts $fd_mak ""

#
# init.cpp & SmuProxy.c & SmuMain<platform>.c
#
puts $fd_mak "[ file join \$(NODE_OBJECTS) SmuDefaults${OBJ_EXT} ]: \$(DEFAULT${ext})"
puts -nonewline $fd_mak "	\$(CC) \$(CFLAGS) "
add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
puts $fd_mak "-c \$(DEFAULT) ${TO_OBJ}\$@"
puts $fd_mak ""
puts $fd_mak "[ file join \$(NODE_OBJECTS) SmuProxy${OBJ_EXT} ]: \$(PROXY${ext})"
puts -nonewline $fd_mak "	\$(CC) \$(CFLAGS) "
add_include_config_directories $fd_mak ${CONFIG_TYPE_DIR}
puts $fd_mak " -c \$(PROXY) ${TO_OBJ}\$@"
puts $fd_mak ""
if {$platform == "windows"} {
	puts $fd_mak "[ file join \$(NODE_OBJECTS) SmuMainWindows${OBJ_EXT} ]: \$(MAIN${ext})"
} else {
	puts $fd_mak "[ file join \$(NODE_OBJECTS) SmuMainUnix${OBJ_EXT} ]: \$(MAIN)"
}
puts $fd_mak "	\$(CC) \$(CFLAGS) -I\"\$(LIB_DIR)\" -c \$(MAIN) ${TO_OBJ}\$@"
puts $fd_mak ""

close $fd_mak
