(* Time-stamp: <modified the 18/08/2010 (at 11:02) by Erwan Jahier>  *)


let init  _ = ()

type var_type = string
(* An var_type can be "bool", "int", or "float" *)

let (get_input_var_name_and_type : unit ->  (string * var_type) list) =
  fun () ->  ["T", "float"; "T1", "float"; "T2", "float"; "T3", "float";"Heat_on", "bool"]

let (get_output_var_name_and_type : unit -> (string * var_type) list) =
  fun () -> ["ok", "bool"]




open Value

let (step :  Value.OfIdent.t ->  Value.OfIdent.t -> bool* Value.OfIdent.t) =
  fun inputs outputs -> 
    let t = 
      try
        Value.OfIdent.get inputs  "T"
      with Not_found -> 
        print_string ("oracle.ml: can not find variable T in the list of sut inputs\n");
	     let inlist = Value.OfIdent.content inputs in
        print_string ("Available variables are: " ^ (String.concat ", " (fst (List.split inlist))));
        print_string ("\n");
        flush stdout;
        exit 2
    in
    let ok =
      match t with
          N(F(f)) ->  f < 10.0
        | _ -> assert false
    in
      (ok, Value.OfIdent.from_list [("ok", B(ok))])

let  (step_try :  Value.OfIdent.t ->  Value.OfIdent.t -> bool* Value.OfIdent.t)=
  fun inputs outputs -> 
    step inputs outputs
