open Data

let (inputs :(string * string) list) = [
	"T", "real"; "T1", "real"; "T2", "real"; "T3", "real"]

let (outputs :(string * string) list) = [
	"Heat_on", "bool"]

let pre_res = ref false
let kill  _ = ()

let (step :  subst list -> subst list)=
  fun inputs -> 
    let res =
      match inputs with
          (_,F(f))::_ -> 
            if f > 9.0 then false else if f < 6.00 then true else !pre_res
        | _ -> assert false
    in
      pre_res := res;
      [ ("Heat_on", B(res)) ]

let mems_i = []
let mems_o = []

let _ = 
  OcamlRM.add_inputs "heat_ctrl2.cmxs" inputs;
  OcamlRM.add_outputs "heat_ctrl2.cmxs" outputs;
  OcamlRM.add_kill "heat_ctrl2.cmxs" kill;
  OcamlRM.add_step "heat_ctrl2.cmxs" step;
  OcamlRM.add_mems "heat_ctrl2.cmxs" mems_i mems_o
