(* Time-stamp: <modified the 13/12/2010 (at 17:16) by Erwan Jahier>  *)



let init  _ = ()

let pre_res = ref false

type var_type = string
(* An var_type can be "bool", "int", or "float" *)

let (get_input_var_name_and_type : unit ->  (string * var_type) list) =
  fun () -> ["T", "float"; "T1", "float"; "T2", "float"; "T3", "float"]


let (get_output_var_name_and_type : unit -> (string * var_type) list) =
  fun () -> ["Heat_on", "bool"]




open Value

let (step :  Value.OfIdent.t ->  Value.OfIdent.t)=
  fun inputs -> 
    let t = Value.OfIdent.get inputs "T"  in
    let res =
      match t with
          N(F(f)) -> if f > 9.0 then false else if f < 6.00 then true else !pre_res
        | _ -> assert false
    in
      pre_res := res;
      Value.OfIdent.from_list [ ("Heat_on", B(res)) ]

let  (step_try :  Value.OfIdent.t ->  Value.OfIdent.t)=
  fun l -> 
    step l
 


(**  Where module Value defines the following types:

     type num = I of int | F of float
     type t = B of bool | N of num
*)
