
(*  
    Demonstrate the use of Lucky from Ocaml.
    
    This is the demo that comes with the presention contained in synchron2005.pdf

    Confere the Makefile for building and use.
*)

open Luc4ocaml 

(* let _ = Graphics.auto_synchronize false *)

let _ = 
  if (Array.length Sys.argv <> 4) then 
    (
      print_string "usage: rabbit <step nb> <step delay> <line|dot>

  where
    <step nb> is the number of steps to perform
    <step delay> is a delay to introduce between each step (otherwise, 
                   the rabbit is to quick and one can not see 
                   that its speed is varying)
    <line|dot> is to indicate whether to use lines or dots to draw
                   the rabbit trajectory.

    e.g.: rabbit 10000 0.0 line

  then type 'g' to go to the next demo.
\n";
      exit 1
    )

(**************************************************************************)
(* Utilities *)

let draw x y =
  if Sys.argv.(3) = "dot" then
    Graphics.plot (truncate x) (truncate y)
  else
    Graphics.lineto (truncate x) (truncate y)

let get_float var sol = 
  try
    match (List.assoc var sol) with F f -> f | _ -> assert false
  with Not_found -> 
    assert false


let det ((p1x,p1y),(p2x,p2y),(p3x,p3y),(p4x,p4y)) =
  ((p2x-.p1x)*.(p4y-.p3y)-.(p2y-.p1y)*.(p4x-.p3x))

(**************************************************************************)
(* Main loop for demo 1 and 2 *)

let rec main_loop rs rd i delay = 
  (* Get the size of the Graphics window *)
  let x_min = F (float_of_int 0)
  and x_max = F (float_of_int (Graphics.size_x ()))
  and y_min = F (float_of_int 0)
  and y_max = F (float_of_int (Graphics.size_y ())) 
  in
  let bounds = [("x_min", x_min);("x_max",x_max);("y_min",y_min);("y_max",y_max)] in

  (* Performing the steps *)
  let (rs', (speed, _rs_locals)) = Luc4ocaml.step rs [] in 
  let (rd', (dir,   _rd_locals)) = Luc4ocaml.step rd (bounds@speed) in 

  (* Drawing the new point onto the Graphics window *)
  let x = get_float "x" dir in 
  let y = get_float "y" dir in 
 
    if Graphics.key_pressed () && (Graphics.read_key () = 'g') then () else 
      (
	if delay <> "0.0" then ignore (Sys.command ("sleep " ^ delay)); 
	draw x y;
	if i > 0 then main_loop rs' rd' (i-1) delay 
      )


open Graphics
let poly_mem = ref [|(0,0)|] 
(* let snapshot = ref (Graphics.create_image 100 100) *)


(**************************************************************************)
(* Main loop for demo 3 and 4 *)

let oc = open_out "rabbit.out"

let rec main_loop_obstacle rs rd ro i delay = 
  (* Get the size of the Graphics window *)
  let x_min = F (float_of_int 0)
  and x_max = F (float_of_int (Graphics.size_x ()))
  and y_min = F (float_of_int 0)
  and y_max = F (float_of_int (Graphics.size_y ())) in
  let bounds = [("x_min", x_min);("x_max",x_max);("y_min",y_min);("y_max",y_max)] in 

  (* Performing the steps *)

  let (rs', (speed, _)) = Luc4ocaml.step rs [] in 
  let (ro', (obstacle_points, _)) = Luc4ocaml.step ro (bounds) in 
  let (rd', (dir, _)) = Luc4ocaml.step rd (bounds@speed@obstacle_points) in  

  (* Drawing the new point onto the Graphics window *)
  let x = get_float "x" dir 
  and y = get_float "y" dir  
  and p1x = get_float "p1x" obstacle_points
  and p2x = get_float "p2x" obstacle_points
  and p3x = get_float "p3x" obstacle_points
  and p4x = get_float "p4x" obstacle_points
  and p1y = get_float "p1y" obstacle_points
  and p2y = get_float "p2y" obstacle_points
  and p3y = get_float "p3y" obstacle_points
  and p4y = get_float "p4y" obstacle_points
  in
  let p1xI = truncate p1x
  and p1yI = truncate p1y
  and p2xI = truncate p2x
  and p2yI = truncate p2y
  and p3xI = truncate p3x
  and p3yI = truncate p3y
  and p4xI = truncate p4x
  and p4yI = truncate p4y
  in 

  let point_list = [(p1xI,p1yI);(p2xI,p2yI);(p3xI,p3yI);(p4xI,p4yI)] in 
  let poly = Array.of_list point_list in
 
    List.iter (fun (x,y) -> output_string oc ((string_of_int x) ^ " " ^ (string_of_int y) ^ " ")) point_list;
    output_string oc "\n"; flush oc;

    let stop =
      if Graphics.key_pressed () then 
	(match (Graphics.read_key ()) with
	   | 'q' -> exit 0
	   | 'g' -> true
	   | _ -> ignore(Graphics.read_key ()); false
	)
      else
	false	  
    in
      if stop then () else (
	if delay <> "0.0" then 
	  ignore (Sys.command ("sleep " ^ delay)); 


	(* erase the previous obstacle *)
	Graphics.set_color (Graphics.rgb 255 255 255);
	Graphics.draw_poly !poly_mem;
	Graphics.set_color (Graphics.rgb 0 0 0);
	
(* 	Graphics.dump_image !snapshot; *)

	draw x y;  
(* 	snapshot := Graphics.get_image 0 0 (size_x ()) (size_y ()); *)
	
	(* draw the new obstable *)
	Graphics.draw_poly poly;
	Graphics.synchronize ();
	poly_mem := poly;

	if i > 0 then main_loop_obstacle rs' rd' ro' (i-1) delay else ()
      )


let launch_demo () = 
  let i = int_of_string Sys.argv.(1) in
  let delay =  Sys.argv.(2) in


(**************************************************************************)
(* Demo 1 *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 1: only lines";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    ( 
      main_loop  
	(Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
	(Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir-line.luc"]) 
	i
	"0.0"; 
      ignore (Graphics.read_key ())
    );
  
(**************************************************************************)
(* Demo 1 bis *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 1 bis: only lines with sleep";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    ( 
      main_loop  
	(Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
	(Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir-line.luc"]) 
	i
	delay; 
      ignore (Graphics.read_key ())
    );
  
(**************************************************************************)
  (* Demo 2 *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 2: lines and curves";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    (
      main_loop
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir.luc"]) 
       i
       "0.0"; 
      ignore (Graphics.read_key ())
    );
  
(**************************************************************************)
  (* Demo 3 *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 3: lines, curves, obstacle";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    (
      main_loop_obstacle
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir-obstacle.luc"]) 
       (Luc4ocaml.make  ~pp:"../../../bin/lucky_cpp" ["obstacle.luc"]) 
       i
       "0.0";
      ignore (Graphics.read_key ())
    );

(**************************************************************************)
(* Demo 4 *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 4: lines, curves, moving obstacle";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    (
      main_loop_obstacle
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir-obstacle.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["moving-obstacle.luc"]) 
       (i*10)
       "0.0"; 
      ignore (Graphics.read_key ())
    );
  
(**************************************************************************)
  (* Demo 4 bis *)
  Graphics.open_graph " ";  Graphics.clear_graph ();  
  Graphics.set_window_title "The Rabbit travel - Demo 4 bis : lines, curves, moving obstacle";  
  Graphics.moveto 100 100;
  if (Graphics.read_key ()) = 'g' then 
    (
      main_loop_obstacle
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp"  ["rabbit-dir-obstacle.luc"]) 
       (Luc4ocaml.make ~pp:"../../../bin/lucky_cpp" ["moving-obstacle3.luc"]) 
       (i*10)
       "0.0"; 
      ignore (Graphics.read_key ())
    )

(**************************************************************************)
let _ = 
  if Sys.argv.(3) = "test" then
    (
      Graphics.open_graph " ";  Graphics.clear_graph ();  
      Graphics.resize_window 500 500;
      Graphics.set_window_title "The Crazy Rabbit travel - test";  
      Graphics.moveto 100 100;

      main_loop_obstacle
	(Luc4ocaml.make ~seed:1 ~pp:"../../../bin/lucky_cpp" ["rabbit-speed.luc"]) 
	(Luc4ocaml.make ~seed:1  ~pp:"../../../bin/lucky_cpp" ["rabbit-dir-obstacle.luc"]) 
	(Luc4ocaml.make ~seed:1 ~pp:"../../../bin/lucky_cpp"  ["moving-obstacle3.luc"]) 
	(int_of_string Sys.argv.(1))
	Sys.argv.(2);
      print_string "that'all folks!\n"
)
  else
    launch_demo ();;
