open LuckyDraw

let solvedraw mode list str  =
     let c = make_bool_expr list str in
     let ss = solve  ~verbose:0 c in
       draw ~mode:mode ~verbose:0  ss 

let solvedrawp mode str list =
  List.iter print_solution (solvedraw mode str list)


let run_bench label max step vars cstr =
    let fd = open_out (label ^ ".data") in
      for n = 1 to (max / step) do
	let t =
	  let t1 = Unix.gettimeofday () in
	  let t2 = 
	    for i=1 to (n*step) do
	      (solvedrawp (1,0,0) vars cstr);
	      set_efficient_mode  ()
	    done;
	    Unix.gettimeofday () 
	  in
	    (t2 -. t1)
	in
	  output_string fd
	    ((string_of_int (n*step)) ^ " " ^ (string_of_float t) ^ "\n");
      done;
      flush fd;
      close_out fd;
      print_string (label ^ " is over \n");
      flush stdout
      



let _ = 
  LuckyDraw.set_seed 1; (* for the non-regression test *)
  if Array.length (Sys.argv) = 1 then
    (
      solvedrawp (10,10,2)  ["x",Float] "x > 10.0 and x <= 20.0" ;
      print_string "______________________________________\n";
      solvedrawp (1,1,2 )  ["x",Int; "y",Int; "Z",Int] 
        "x+y+z=50 and x+y+z > -100 and x < 100 and y < 100 and z < 100";
      print_string "______________________________________\n";
      solvedrawp (1,0,0)  ["x",Bool; "y",Bool; "Z",Bool] "true"
    )
  else
    (
(*       run_bench "bench1" 3000 100 ["x",Int; "y",Int; "Z",Int] "x+y+z=50 and x+y+z > -100 and x < 100 and y < 100 and z < 100"; *)
      run_bench 
	"bench2" 1 1
	[
	  "a1", Bool;"a2", Bool;"a3", Bool;"a4", Bool;"a5", Bool;"a6", Bool;"a7", Bool;"a8", Bool;"a9", Bool;"a10", Bool;
	  "a11", Bool; "a12", Bool; "a13", Bool; "a14", Bool; "a15", Bool; "a16", Bool; "a17", Bool; "a18", Bool; "a19", Bool; "a20", Bool;
	  "a21", Bool; "a22", Bool; "a23", Bool; "a24", Bool; "a25", Bool; "a26", Bool; "a27", Bool; "a28", Bool; "a29", Bool; "a30", Bool; 
	  "a31", Bool; "a32", Bool; "a33", Bool; "a34", Bool; "a35", Bool; "a36", Bool; "a37", Bool; "a38", Bool; "a39", Bool; "a40", Bool; 
	  "a41", Bool; "a42", Bool; "a43", Bool; "a44", Bool; "a45", Bool; "a46", Bool; "a47", Bool; "a48", Bool; "a49", Bool; "a50", Bool;
	  "a51", Bool; "a52", Bool; "a53", Bool; "a54", Bool; "a55", Bool; "a56", Bool; "a57", Bool; "a58", Bool; "a59", Bool; "a60", Bool;
	  "a61", Bool; "a62", Bool; "a63", Bool; "a64", Bool; "a65", Bool; "a66", Bool; "a67", Bool; "a68", Bool; "a69", Bool; "a70", Bool;
	  "a71", Bool; "a72", Bool; "a73", Bool; "a74", Bool; "a75", Bool; "a76", Bool; "a77", Bool; "a78", Bool; "a79", Bool; "a80", Bool;
	  "a81", Bool; "a82", Bool; "a83", Bool; "a84", Bool; "a85", Bool; "a86", Bool; "a87", Bool; "a88", Bool; "a89", Bool; "a90", Bool;
	  "a91", Bool; "a92", Bool; "a93", Bool; "a94", Bool; "a95", Bool; "a96", Bool; "a97", Bool; "a98", Bool; "a99", Bool; "a100", Bool
	]
	"true";
(*       run_bench   *)
(* 	"bench3" 100 10   *)
(* 	[ *)
(* 	  "a1", Float;"a2", Float;"a3", Float;"a4", Float;"a5", Float;"a6", Float;"a7", Float;"a8", Float;"a9", Float;"a10", Float *)
(* 	] *)
(* 	"true"; *)
(*       run_bench   *)
(* 	"bench4" 100 10  *)
(* 	[ *)
(* 	  "a1", Float;"a2", Float;"a3", Float;"a4", Float;"a5", Float;"a6", Float;"a7", Float;"a8", Float;"a9", Float;"a10", Float *)
(* 	] *)
(* 	"a1+a2+a3>0 and a4-a5+a6+a2 < 1 and a7+a8+a9+a10 < 2"; *)
    )
;;
