(* *)

(** C Interface for luckyDraw: caml part *)

(*  ********************************************************************** *)
(** {2 Registering Caml functions for C use} *)
(*  ********************************************************************** *)

let register () =
  (* Boolean contructors *)
  Callback.register "lucky_and_b" LuckyDraw.and_b;
  Callback.register "lucky_or_b" LuckyDraw.or_b;
  Callback.register "lucky_xor_b" LuckyDraw.xor_b;
  Callback.register "lucky_impl_b" LuckyDraw.impl_b;
  Callback.register "lucky_eq_b" LuckyDraw.eq_b;
  Callback.register "lucky_not_b" LuckyDraw.not_b;
  Callback.register "lucky_true_b" LuckyDraw.true_b;
  Callback.register "lucky_false_b" LuckyDraw.false_b;
  Callback.register "lucky_ite_b" LuckyDraw.ite_b;
  Callback.register "lucky_var_b" LuckyDraw.var_b;

  (* Integer contructors *)
  Callback.register "lucky_var_i" LuckyDraw.var_i;
  Callback.register "lucky_val_i" LuckyDraw.val_i;
  Callback.register "lucky_eq_i" LuckyDraw.eq_i;
  Callback.register "lucky_sup_i" LuckyDraw.sup_i;
  Callback.register "lucky_supeq_i" LuckyDraw.supeq_i;
  Callback.register "lucky_inf_i" LuckyDraw.inf_i;
  Callback.register "lucky_infeq_i" LuckyDraw.infeq_i;
  Callback.register "lucky_ite_i" LuckyDraw.ite_i;
  Callback.register "lucky_sum_i" LuckyDraw.sum_i;
  Callback.register "lucky_diff_i" LuckyDraw.diff_i;
  Callback.register "lucky_prod_i" LuckyDraw.prod_i;
  Callback.register "lucky_quot_i" LuckyDraw.quot_i;
  Callback.register "lucky_mod_i" LuckyDraw.mod_i;
  Callback.register "lucky_div_i" LuckyDraw.div_i;
  Callback.register "lucky_uminus_i" LuckyDraw.uminus_i;

  (* Float contructors *)
  Callback.register "lucky_var_f" LuckyDraw.var_f;
  Callback.register "lucky_val_f" LuckyDraw.val_f;
  Callback.register "lucky_eq_f" LuckyDraw.eq_f;
  Callback.register "lucky_sup_f" LuckyDraw.sup_f;
  Callback.register "lucky_supeq_f" LuckyDraw.supeq_f;
  Callback.register "lucky_inf_f" LuckyDraw.inf_f;
  Callback.register "lucky_infeq_f" LuckyDraw.infeq_f;
  Callback.register "lucky_ite_f" LuckyDraw.ite_f;
  Callback.register "lucky_sum_f" LuckyDraw.sum_f;
  Callback.register "lucky_diff_f" LuckyDraw.diff_f;
  Callback.register "lucky_prod_f" LuckyDraw.prod_f;
  Callback.register "lucky_quot_f" LuckyDraw.quot_f;
  Callback.register "lucky_uminus_f" LuckyDraw.uminus_f;

  (* solving and drawing *)
  Callback.register "lucky_solve" LuckyDraw.solve;
  Callback.register "lucky_draw" LuckyDraw.draw;
  Callback.register "lucky_set_efficient_mode" LuckyDraw.set_efficient_mode;
  Callback.register "lucky_set_fair_mode" LuckyDraw.set_fair_mode;

  (* pretty-printing and misc *)
  Callback.register "lucky_bool_expr_to_string" LuckyDraw.bool_expr_to_string;
  Callback.register "lucky_set_seed" LuckyDraw.set_seed;

  ()

(*  ********************************************************************** *)
(** {2 Main} *)
(*  ********************************************************************** *)

let _ = register ()
