#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <caml/callback.h>
#include <caml/alloc.h>
#include <caml/memory.h>
#include "luckyDrawC_stubs.h"


int main(int argc, char** argv)
{
  char* argvv[1] = { NULL };
  solutions sols;
    
  solutions_set solset = { 0 };
  int_expr i0 = { 0 };
  int_expr i1 = { 0 };
  int_expr i2 = { 0 };
  int_expr i3 = { 0 };
  int_expr i4 = { 0 };
  bool_expr b0 = { 0 };
  bool_expr b1 = { 0 };
  bool_expr b2 = { 0 };
  bool_expr b3 = { 0 };

  // caml_startup(argvv);
  lucky_caml_init();
  lucky_set_seed(1);

  Begin_roots5(i0.v,i1.v,i2.v,i3.v,i4.v);
  Begin_roots5(b0.v,b1.v,b2.v, b3.v, solset.v);

  /* builds the expression if b then x+y else x-y >= 0 */
  i0 = lucky_var_i("x");
  i1 = lucky_var_i("y");
  i2 = lucky_sum_i(i0,i1);  /* x+y */
  i3 = lucky_diff_i(i0,i1); /* x-y */
  i0 = lucky_val_i(3);
  i1 = lucky_val_i(0);
  b0 = lucky_var_b("b");
  b1 = lucky_supeq_i(i2,i0);
  b2 = lucky_infeq_i(i3,i0);
  b3 = lucky_supeq_i(i2,i1);
  b0 = lucky_ite_b(b3,b1,b2);

  /*
  i4 = lucky_ite_i(b0,i2,i3);
  b1 = lucky_supeq_i(i4,i1);
  b2 = lucky_supeq_i(i2,i0);
  */
  fprint_bool_expr(stdout,b0);
  
  printf("solve : \n");
  fflush(stdout);
  solset = lucky_solve(b0);
  printf("draw...  \n");
  fflush(stdout);
  sols = lucky_draw(2,1,1,8,solset);
  
  printf("Les solutions sont : \n");
  fflush(stdout);
  fprint_solutions(stdout, sols);
  fflush(stdout);

  solutions_free(sols);
  End_roots();
  End_roots();  
  return 0;
}
