#---------------------------------------------------------
# Ptk (Parenthesized tk)
#---------------------------------------------------------
# ptk-leaves.tcl
# - complement to ptk.tcl
# - compound leaves
#---------------------------------------------------------

# showvar
_def_props {
   {kind          outer  params    components}
   {showvar       packer   {var}   {labelframe label}}
}
proc ptk::_add_showvar { kind var opts } {
   ptk::DBG "ptk::showvar $var $opts"
   set it  [ ptk::_new_leaf labelframe ]
   $it configure -text $var
   eval "$it configure $opts"
   ::label $it.lbl
   $it.lbl configure -textvariable $var
   pack $it.lbl -in $it -side top -expand 1 -anchor center -fill x
   return $it
}

interp alias {} ptk::_configure_showvar {} ptk::_configure_basic
interp alias {} ptk::_configure_showvar_labelframe {} ptk::_configure_basic
proc ptk::_configure_showvar_label { it opts } {
	eval "$it.lbl configure $opts"
}

#--------------------------------------------------------------
# combobox
# wrapper for Bryan Oakley's combobox
# opts -> passed to combobox
package require combobox 1.06
interp alias {} ::bo_combobox {} ::combobox::combobox
#--------------------------------------------------------------

_def_props {
   {kind      outer  params              components}
   {combobox  packer {title var values}  {combobox}}
}

proc set_combo_values { zecombo values } {
   ptk::DBG "ptk::set_combo_values $zecombo $values"
   # this works for ttk::combobox
   # $zecombo configure -values $values
   # but not in B.O. combo, insert one by one
   foreach x $values {
      ptk::DBG "   insert combo value $zecombo $x"
      $zecombo list insert end "$x"
   }
}

proc ptk::_add_combobox { kind title var values opts } {
   ptk::DBG "ptk::combobox $title $var $values $opts"
   set it  [ ptk::_new_leaf labelframe ]
   $it configure -text $title
   ::bo_combobox $it.cb
   $it.cb configure -textvariable $var
   set_combo_values $it.cb $values
   eval "$it.cb configure $opts"
   pack $it.cb -in $it -side top -expand 1 -anchor center -fill x
	return $it
}

proc ptk::_configure_combobox { it opts } {
   eval "$it.cb configure $opts"
}
interp alias {} ptk::_configure_combobox_combobox {} ptk::_configure_combobox

#--------------------------------------------------------------
# select_file
# opts are passed to tk_getOpenFile
# usefull -filetypes, e.g.:
#
# set srcfiles {
#    {{Cfiles} {.c .h .cc}}
#    {{All files} *}
# }
# tk::add select_file {Src file} ::zefile -filetypes $srcfiles
#--------------------------------------------------------------

_def_props {
   {kind        outer  params       components}
   {select_file packer {title var}  {tk_getOpenFile}}
}

namespace eval ptk {
	namespace eval sfile {
		variable title
		variable var
		variable opts
	}
}

proc _configure_select_file_tk_getOpenFile { $it $opts } {
	lappend ptk::sfile::opts($it) {*}$opts
}
interp alias {} ptk::_configure_select_file {} ptk::_configure_select_file_tk_getOpenFile

proc ptk::_do_select_file { it } {
	set title $ptk::sfile::title($it)
	set var $ptk::sfile::var($it)
	set opts $ptk::sfile::opts($it)
#puts "set $var \[tk_getOpenFile -title $title {*}$opts\]"
	set $var [tk_getOpenFile -title $title {*}$opts]
}

proc ptk::_add_select_file { kind title var opts } {
   ptk::DBG "ptk::select_file $title $var $opts"
   set it [ ptk::_new_leaf frame ]
	# store var and opts
	set ptk::sfile::title($it) $title
	set ptk::sfile::var($it) $var
	set ptk::sfile::opts($it) $opts
   [STDW label] $it.l -text $title
   [STDW entry] $it.e -textvariable $var
   [STDW button] $it.b -image $icons::open24
   # nightmare to pass complex command to -command !!!!
   #set cmd "set $var \[ tk_getOpenFile -title \"$title\" -filetypes \{ $filetypes \} \]"
#puts cmd=$cmd
   #$it.b configure -command "eval $cmd"
   $it.b configure -command "ptk::_do_select_file $it"
   pack $it.l -side left -expand 0 -anchor center -fill none
   pack $it.e -side left -expand 1 -anchor center -fill x
   pack $it.b -side left -expand 0 -anchor center -fill none
	return $it
}
