
#
# prints a short manual for avalaible items
#
#

proc ptk::help { } {
	set nodes {}
	set leaves {}
	foreach kind [array names ptk::item_props] {
		if { [dict exists $ptk::item_props($kind) "inner"] } {
			puts "kind=$kind is a node"
			lappend nodes $kind
		} else {
			puts "kind=$kind is a leaf"
			lappend leaves $kind
		}
	}
	foreach np $nodes { ptk::help_node $np }
}

proc ptk::help_node { kind } {
	puts -nonewline "ptk::begin $kind"
	foreach p [ptk::get_prop $kind params] {
		puts -nonewline " <$p>" 
	}
	set components [ptk::get_prop $kind components]
	if { $components != {} } then {
		set fc [lindex $components 0]
		puts -nonewline " ?$fc opts?"
	}
	puts " { panel-list }"
}
