#
# utility to increase/decrease all font sizes
#
#
namespace eval ezfont {
}

# just for testing
proc ezfont::visit_all {path} {
   set cls [winfo class $path]
   if { [catch { $path cget -font } res] } {
      set fnt "no font"
   } else {
      set fnt "font=$res ([font actual $res])"
   }
   #puts "$cls $path $fnt"
   foreach child [winfo children $path] {
      visit_all $child
   }
}

# scale DEFAULT fonts by x% (can be negative)
# First call:
# - stores current size 
# - scale them
# Other calls:
# - scale with respect to the initial ones

variable ezfont::scale_dflt

proc ezfont::scale { pc } {
	foreach ff [font names] {
		if { ! [info exist ezfont::scale_dflt($ff)] } then {
			set ezfont::scale_dflt($ff) [font configure $ff -size]
		}
		set dfltsize $ezfont::scale_dflt($ff)
		set newsize [expr round (((100.0 + $pc) * $dfltsize) / 100.0)]
		#puts "$ff: $dfltsize -> $newsize"
		font configure $ff -size $newsize
	}
}
